/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference.sys.job;

import io.crate.expression.reference.sys.job.ContextLog;
import io.crate.expression.reference.sys.job.JobContext;
import io.crate.planner.operators.StatementClassifier;
import java.util.UUID;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class JobContextLog
implements ContextLog,
Accountable {
    private final JobContext jobContext;
    @Nullable
    private final String errorMessage;
    private final long ended;

    public JobContextLog(JobContext jobContext, @Nullable String errorMessage) {
        this.jobContext = jobContext;
        this.errorMessage = errorMessage;
        this.ended = System.currentTimeMillis();
    }

    @VisibleForTesting
    public JobContextLog(JobContext jobContext, @Nullable String errorMessage, long ended) {
        this.jobContext = jobContext;
        this.errorMessage = errorMessage;
        this.ended = ended;
    }

    public UUID id() {
        return this.jobContext.id();
    }

    @Nullable
    public String username() {
        return this.jobContext.username();
    }

    public String statement() {
        return this.jobContext.stmt();
    }

    public long started() {
        return this.jobContext.started();
    }

    @Nullable
    public StatementClassifier.Classification classification() {
        return this.jobContext.classification();
    }

    @Override
    public long ended() {
        return this.ended;
    }

    @Nullable
    public String errorMessage() {
        return this.errorMessage;
    }

    public long ramBytesUsed() {
        long size = 0L;
        size += 32L;
        size += this.errorMessage == null ? 0L : (long)this.errorMessage.length();
        size += 52L;
        return RamUsageEstimator.alignObjectSize((long)(size += (long)this.jobContext.stmt().length()));
    }
}

