/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar;

import io.crate.data.Input;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.functions.TypeVariableConstraint;
import io.crate.types.DataTypes;
import io.crate.types.TypeSignature;
import java.util.List;

public class CollectionAverageFunction
extends Scalar<Double, List<Object>> {
    public static final String NAME = "collection_avg";

    public static void register(Functions.Builder builder) {
        builder.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(TypeSignature.parse("array(E)")).returnType(DataTypes.DOUBLE.getTypeSignature()).typeVariableConstraints(TypeVariableConstraint.typeVariable("E")).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), CollectionAverageFunction::new);
    }

    private CollectionAverageFunction(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
    }

    @Override
    public Double evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<List<Object>> ... args) {
        List values = (List)args[0].value();
        if (values == null) {
            return null;
        }
        double sum = 0.0;
        long count = 0L;
        for (Object value : values) {
            sum += ((Number)value).doubleValue();
            ++count;
        }
        if (count > 0L) {
            return sum / (double)count;
        }
        return null;
    }
}

