/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar;

import io.crate.expression.scalar.HasPrivilegeFunction;
import io.crate.metadata.FunctionName;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.Scalar;
import io.crate.metadata.Schemas;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.pgcatalog.PgCatalogTableDefinitions;
import io.crate.role.Permission;
import io.crate.role.Role;
import io.crate.role.Roles;
import io.crate.role.Securable;
import io.crate.types.DataTypes;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Locale;

public class HasSchemaPrivilegeFunction {
    public static final FunctionName NAME = new FunctionName("pg_catalog", "has_schema_privilege");

    public static boolean checkBySchemaName(Roles roles, Role user, Object schema, Collection<Permission> permissions, Schemas schemas) {
        String schemaName = (String)schema;
        boolean result = false;
        for (Permission permission : permissions) {
            if (permission == Permission.DQL && PgCatalogTableDefinitions.isPgCatalogOrInformationSchema(schemaName)) {
                return true;
            }
            result |= roles.hasPrivilege(user, permission, Securable.SCHEMA, schemaName);
        }
        return result;
    }

    public static boolean checkBySchemaOid(Roles roles, Role user, Object schema, Collection<Permission> permissions, Schemas schemas) {
        Integer schemaOid = (Integer)schema;
        boolean result = false;
        for (Permission permission : permissions) {
            if (permission == Permission.DQL && PgCatalogTableDefinitions.isPgCatalogOrInformationSchema(schemaOid)) {
                return true;
            }
            result |= roles.hasSchemaPrivilege(user, permission, schemaOid);
        }
        return result;
    }

    public static Collection<Permission> parsePermissions(String permissionNames) {
        String[] permissions;
        HashSet<Permission> toCheck = new HashSet<Permission>();
        for (String p : permissions = permissionNames.toLowerCase(Locale.ENGLISH).split(",")) {
            if ((p = p.trim()).equals("create")) {
                toCheck.add(Permission.DDL);
                continue;
            }
            if (p.equals("usage")) {
                toCheck.add(Permission.DQL);
                continue;
            }
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Unrecognized permission: %s", p));
        }
        return toCheck;
    }

    public static void register(Functions.Builder module) {
        module.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature()).returnType(DataTypes.BOOLEAN.getTypeSignature()).features(EnumSet.of(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL)).build(), (signature, boundSignature) -> new HasPrivilegeFunction((Signature)signature, (BoundSignature)boundSignature, HasPrivilegeFunction::userByName, HasSchemaPrivilegeFunction::checkBySchemaName, HasSchemaPrivilegeFunction::parsePermissions));
        module.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(DataTypes.INTEGER.getTypeSignature(), DataTypes.STRING.getTypeSignature()).returnType(DataTypes.BOOLEAN.getTypeSignature()).features(EnumSet.of(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL)).build(), (signature, boundSignature) -> new HasPrivilegeFunction((Signature)signature, (BoundSignature)boundSignature, HasPrivilegeFunction::userByName, HasSchemaPrivilegeFunction::checkBySchemaOid, HasSchemaPrivilegeFunction::parsePermissions));
        module.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature()).returnType(DataTypes.BOOLEAN.getTypeSignature()).features(EnumSet.of(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL)).build(), (signature, boundSignature) -> new HasPrivilegeFunction((Signature)signature, (BoundSignature)boundSignature, HasPrivilegeFunction::userByName, HasSchemaPrivilegeFunction::checkBySchemaName, HasSchemaPrivilegeFunction::parsePermissions));
        module.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(DataTypes.STRING.getTypeSignature(), DataTypes.INTEGER.getTypeSignature(), DataTypes.STRING.getTypeSignature()).returnType(DataTypes.BOOLEAN.getTypeSignature()).features(EnumSet.of(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL)).build(), (signature, boundSignature) -> new HasPrivilegeFunction((Signature)signature, (BoundSignature)boundSignature, HasPrivilegeFunction::userByName, HasSchemaPrivilegeFunction::checkBySchemaOid, HasSchemaPrivilegeFunction::parsePermissions));
        module.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(DataTypes.INTEGER.getTypeSignature(), DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature()).returnType(DataTypes.BOOLEAN.getTypeSignature()).features(EnumSet.of(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL)).build(), (signature, boundSignature) -> new HasPrivilegeFunction((Signature)signature, (BoundSignature)boundSignature, HasPrivilegeFunction::userByOid, HasSchemaPrivilegeFunction::checkBySchemaName, HasSchemaPrivilegeFunction::parsePermissions));
        module.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(DataTypes.INTEGER.getTypeSignature(), DataTypes.INTEGER.getTypeSignature(), DataTypes.STRING.getTypeSignature()).returnType(DataTypes.BOOLEAN.getTypeSignature()).features(EnumSet.of(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL)).build(), (signature, boundSignature) -> new HasPrivilegeFunction((Signature)signature, (BoundSignature)boundSignature, HasPrivilegeFunction::userByOid, HasSchemaPrivilegeFunction::checkBySchemaOid, HasSchemaPrivilegeFunction::parsePermissions));
    }

    private HasSchemaPrivilegeFunction() {
    }
}

