/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar;

import io.crate.data.Input;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Symbol;
import io.crate.lucene.LuceneQueryBuilder;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataTypes;
import java.util.List;
import org.apache.lucene.search.Query;

public class Ignore3vlFunction
extends Scalar<Boolean, Boolean> {
    public static final String NAME = "ignore3vl";
    public static final Signature SIGNATURE = Signature.builder("ignore3vl", FunctionType.SCALAR).argumentTypes(DataTypes.BOOLEAN.getTypeSignature()).returnType(DataTypes.BOOLEAN.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.NOTNULL).build();

    public static void register(Functions.Builder module) {
        module.add(SIGNATURE, Ignore3vlFunction::new);
    }

    public Ignore3vlFunction(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
    }

    @Override
    public Boolean evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Boolean> ... args) {
        assert (args.length == 1) : "ignore3vl expects exactly 1 argument, got: " + args.length;
        Boolean value = (Boolean)args[0].value();
        if (value == null) {
            return Boolean.FALSE;
        }
        return value;
    }

    @Override
    public Query toQuery(Function function, LuceneQueryBuilder.Context context) {
        List<Symbol> args = function.arguments();
        assert (args.size() == 1) : "ignore3vl expects exactly 1 argument, got: " + args.size();
        return args.get(0).accept(context.visitor(), context);
    }
}

