/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar;

import io.crate.data.Input;
import io.crate.data.Row;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataTypes;
import io.crate.types.RowType;

public final class SubscriptRecordFunction
extends Scalar<Object, Object> {
    public static final String NAME = "_subscript_record";
    public static final Signature SIGNATURE = Signature.builder("_subscript_record", FunctionType.SCALAR).argumentTypes(RowType.EMPTY.getTypeSignature(), DataTypes.STRING.getTypeSignature()).returnType(DataTypes.UNDEFINED.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC).build();
    private final RowType rowType;

    public static void register(Functions.Builder module) {
        module.add(SIGNATURE, SubscriptRecordFunction::new);
    }

    public SubscriptRecordFunction(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
        this.rowType = (RowType)boundSignature.argTypes().get(0);
    }

    @Override
    @SafeVarargs
    public final Object evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Object> ... args) {
        Row record = (Row)args[0].value();
        if (record == null) {
            return null;
        }
        String fieldName = (String)args[1].value();
        int idx = this.rowType.fieldNames().indexOf(fieldName);
        if (idx < 0) {
            throw new IllegalStateException("Couldn't find fieldname `" + fieldName + "` within RowType `" + String.valueOf(this.rowType) + "`");
        }
        return record.get(idx);
    }
}

