/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar;

import io.crate.data.Input;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataTypes;
import io.crate.types.FloatVectorType;

public class VectorSimilarityFunction
extends Scalar<Float, float[]> {
    public static void register(Functions.Builder module) {
        module.add(Signature.builder("vector_similarity", FunctionType.SCALAR).argumentTypes(FloatVectorType.INSTANCE_ONE.getTypeSignature(), FloatVectorType.INSTANCE_ONE.getTypeSignature()).returnType(DataTypes.FLOAT.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), VectorSimilarityFunction::new);
    }

    private VectorSimilarityFunction(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
    }

    @Override
    public Float evaluate(TransactionContext txnCtx, NodeContext nodeContext, Input<float[]> ... args) {
        assert (args.length == 2) : "Invalid number of arguments";
        float[] v1 = (float[])args[0].value();
        float[] v2 = (float[])args[1].value();
        if (v1 == null || v2 == null) {
            return null;
        }
        if (v1.length != v2.length) {
            throw new IllegalArgumentException("Vectors must have same length");
        }
        return Float.valueOf(FloatVectorType.SIMILARITY_FUNC.compare(v1, v2));
    }
}

