/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.arithmetic;

import io.crate.data.Input;
import io.crate.expression.scalar.UnaryScalar;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.function.UnaryOperator;

public final class TruncFunction {
    public static final String NAME = "trunc";

    public static void register(Functions.Builder module) {
        for (DataType<? extends Number> type : DataTypes.NUMERIC_PRIMITIVE_TYPES) {
            DataType<?> returnType = DataTypes.getIntegralReturnType(type);
            assert (returnType != null) : "Could not get integral type of " + String.valueOf(type);
            module.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(type.getTypeSignature()).returnType(returnType.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).forbidCoercion().build(), (signature, boundSignature) -> new UnaryScalar<Number, Number>((Signature)signature, (BoundSignature)boundSignature, (DataType<Number>)type, n -> {
                double val = n.doubleValue();
                UnaryOperator f = val >= 0.0 ? Math::floor : Math::ceil;
                return (Number)returnType.sanitizeValue(f.apply(val));
            }));
        }
        module.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(DataTypes.DOUBLE.getTypeSignature(), DataTypes.INTEGER.getTypeSignature()).returnType(DataTypes.DOUBLE.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), TruncFunction::createTruncWithMode);
    }

    private static Scalar<Number, Number> createTruncWithMode(Signature signature, BoundSignature boundSignature) {
        return new Scalar<Number, Number>(signature, boundSignature){

            @Override
            public Number evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Number> ... args) {
                Number n = (Number)args[0].value();
                Number nd = (Number)args[1].value();
                if (null == n || null == nd) {
                    return null;
                }
                double val = n.doubleValue();
                int numDecimals = nd.intValue();
                RoundingMode mode = val >= 0.0 ? RoundingMode.FLOOR : RoundingMode.CEILING;
                return BigDecimal.valueOf(val).setScale(numDecimals, mode).doubleValue();
            }
        };
    }
}

