/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.conditional;

import io.crate.data.Input;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import java.util.Comparator;

abstract class ConditionalCompareFunction
extends Scalar<Object, Object>
implements Comparator<Object> {
    ConditionalCompareFunction(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
    }

    @Override
    public Object evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Object>[] args) {
        assert (args != null) : "args must not be null";
        assert (args.length > 0) : "number of args must be > 1";
        if (args.length == 1) {
            return args[0].value();
        }
        Object result = null;
        for (Input<Object> input : args) {
            result = this.extrema(result, input.value());
        }
        return result;
    }

    private Object extrema(Object value1, Object value2) {
        if (value1 == null) {
            return value2;
        }
        if (value2 == null) {
            return value1;
        }
        return this.compare(value1, value2) < 0 ? value1 : value2;
    }
}

