/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.postgres;

import io.crate.data.Input;
import io.crate.metadata.FunctionName;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.role.Role;
import io.crate.types.DataTypes;

public class PgGetUserByIdFunction
extends Scalar<String, Integer> {
    public static void register(Functions.Builder builder) {
        FunctionName name = new FunctionName("pg_catalog", "pg_get_userbyid");
        builder.add(Signature.builder(name, FunctionType.SCALAR).argumentTypes(DataTypes.INTEGER.getTypeSignature()).returnType(DataTypes.STRING.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), PgGetUserByIdFunction::new);
    }

    private PgGetUserByIdFunction(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
    }

    @Override
    @SafeVarargs
    public final String evaluate(TransactionContext txnCtx, NodeContext nodeContext, Input<Integer> ... args) {
        Integer oid = (Integer)args[0].value();
        if (oid == null) {
            return null;
        }
        Role user = nodeContext.roles().findUser(oid);
        if (user == null) {
            return "unknown (OID=" + oid + ")";
        }
        return user.name();
    }
}

