/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.systeminformation;

import io.crate.data.Input;
import io.crate.metadata.FunctionName;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.protocols.postgres.types.PGTypes;
import io.crate.types.ArrayType;
import io.crate.types.DataType;
import io.crate.types.DataTypes;

public final class FormatTypeFunction
extends Scalar<String, Object> {
    private static final String NAME = "format_type";
    private static final FunctionName FQN = new FunctionName("pg_catalog", "format_type");

    public static void register(Functions.Builder module) {
        module.add(Signature.builder(FQN, FunctionType.SCALAR).argumentTypes(DataTypes.INTEGER.getTypeSignature(), DataTypes.INTEGER.getTypeSignature()).returnType(DataTypes.STRING.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC).build(), FormatTypeFunction::new);
    }

    public FormatTypeFunction(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
    }

    @Override
    @SafeVarargs
    public final String evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Object> ... args) {
        Integer typeOid = (Integer)args[0].value();
        if (typeOid == null) {
            return null;
        }
        DataType<Object> type = PGTypes.fromOID(typeOid);
        if (type == null) {
            return "???";
        }
        int dimensions = 0;
        while (type instanceof ArrayType) {
            type = ((ArrayType)type).innerType();
            ++dimensions;
        }
        if (dimensions == 0) {
            return type.getName();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(type.getName());
        for (int i = 0; i < dimensions; ++i) {
            sb.append("[]");
        }
        return sb.toString();
    }
}

