/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.timestamp;

import io.crate.data.Input;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataTypes;
import io.crate.types.TypeSignature;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.EnumSet;

public final class NowFunction
extends Scalar<Long, Object> {
    public static final String NAME = "now";

    public static void register(Functions.Builder module) {
        module.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(new TypeSignature[0]).returnType(DataTypes.TIMESTAMPZ.getTypeSignature()).features(EnumSet.of(Scalar.Feature.NOTNULL)).build(), NowFunction::new);
    }

    public NowFunction(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
    }

    @Override
    @SafeVarargs
    public final Long evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Object> ... args) {
        return ChronoUnit.MILLIS.between(Instant.EPOCH, txnCtx.currentInstant());
    }
}

