/*
 * Decompiled with CFR 0.152.
 */
package io.crate.fdw;

import io.crate.fdw.CreateUserMappingRequest;
import io.crate.fdw.ServersMetadata;
import java.util.Locale;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.Priority;

public class AddUserMappingTask
extends AckedClusterStateUpdateTask<AcknowledgedResponse> {
    private final CreateUserMappingRequest request;

    AddUserMappingTask(CreateUserMappingRequest request) {
        super(Priority.NORMAL, request);
        this.request = request;
    }

    @Override
    protected AcknowledgedResponse newResponse(boolean acknowledged) {
        return new AcknowledgedResponse(acknowledged);
    }

    @Override
    public ClusterState execute(ClusterState currentState) throws Exception {
        ServersMetadata serversMetadata = (ServersMetadata)currentState.metadata().custom("servers");
        if (serversMetadata == null) {
            throw new ResourceNotFoundException(String.format(Locale.ENGLISH, "Server `%s` not found", this.request.server()), new Object[0]);
        }
        ServersMetadata updatedServersMetadata = serversMetadata.addUser(this.request.server(), this.request.ifNotExists(), this.request.userName(), this.request.options());
        if (updatedServersMetadata == serversMetadata) {
            return currentState;
        }
        return ClusterState.builder(currentState).metadata(Metadata.builder(currentState.metadata()).putCustom("servers", updatedServersMetadata)).build();
    }
}

