/*
 * Decompiled with CFR 0.152.
 */
package io.crate.fdw;

import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import java.io.IOException;
import java.util.Collection;
import java.util.SequencedCollection;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;

public class CreateForeignTableRequest
extends AcknowledgedRequest<CreateForeignTableRequest> {
    private final RelationName tableName;
    private boolean ifNotExists;
    private final Collection<Reference> columns;
    private final String server;
    private final Settings options;

    public CreateForeignTableRequest(RelationName tableName, boolean ifNotExists, SequencedCollection<Reference> columns, String server, Settings options) {
        this.tableName = tableName;
        this.ifNotExists = ifNotExists;
        this.columns = columns;
        this.server = server;
        this.options = options;
    }

    public CreateForeignTableRequest(StreamInput in) throws IOException {
        this.tableName = new RelationName(in);
        this.ifNotExists = in.readBoolean();
        this.columns = in.readList(Reference::fromStream);
        this.server = in.readString();
        this.options = Settings.readSettingsFromStream(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.tableName.writeTo(out);
        out.writeBoolean(this.ifNotExists);
        out.writeCollection(this.columns, Reference::toStream);
        out.writeString(this.server);
        Settings.writeSettingsToStream(out, this.options);
    }

    public RelationName tableName() {
        return this.tableName;
    }

    public boolean ifNotExists() {
        return this.ifNotExists;
    }

    public Collection<Reference> columns() {
        return this.columns;
    }

    public String server() {
        return this.server;
    }

    public Settings options() {
        return this.options;
    }
}

