/*
 * Decompiled with CFR 0.152.
 */
package io.crate.fdw;

import java.io.IOException;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;

public class CreateServerRequest
extends AcknowledgedRequest<CreateServerRequest> {
    private final String name;
    private final String fdw;
    private final String owner;
    private final boolean ifNotExists;
    private final Settings options;

    public CreateServerRequest(String name, String fdw, String owner, boolean ifNotExists, Settings options) {
        this.name = name;
        this.fdw = fdw;
        this.owner = owner;
        this.ifNotExists = ifNotExists;
        this.options = options;
    }

    public CreateServerRequest(StreamInput in) throws IOException {
        this.name = in.readString();
        this.fdw = in.readString();
        this.owner = in.readString();
        this.ifNotExists = in.readBoolean();
        this.options = Settings.readSettingsFromStream(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeString(this.fdw);
        out.writeString(this.owner);
        out.writeBoolean(this.ifNotExists);
        Settings.writeSettingsToStream(out, this.options);
    }

    public String name() {
        return this.name;
    }

    public String fdw() {
        return this.fdw;
    }

    public String owner() {
        return this.owner;
    }

    public Settings options() {
        return this.options;
    }

    public boolean ifNotExists() {
        return this.ifNotExists;
    }
}

