/*
 * Decompiled with CFR 0.152.
 */
package io.crate.interval;

import io.crate.interval.IntervalParser;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.jetbrains.annotations.Nullable;
import org.joda.time.Period;

final class NumericalIntervalParser {
    private NumericalIntervalParser() {
    }

    static Period apply(String value, @Nullable IntervalParser.Precision start, @Nullable IntervalParser.Precision end) {
        try {
            return NumericalIntervalParser.roundToPrecision(NumericalIntervalParser.parseInteger(value), IntervalParser.parseMilliSeconds(value), start, end);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid interval format: " + value);
        }
    }

    private static Period roundToPrecision(int value, int millis, @Nullable IntervalParser.Precision start, @Nullable IntervalParser.Precision end) {
        if (start == null && end == null) {
            return NumericalIntervalParser.buildSecondsWithMillisPeriod(value, millis);
        }
        if (start == IntervalParser.Precision.YEAR) {
            if (end == null) {
                return Period.years((int)value);
            }
            if (end == IntervalParser.Precision.MONTH) {
                return Period.months((int)value);
            }
        }
        if (start == IntervalParser.Precision.MONTH && end == null) {
            return Period.months((int)value);
        }
        if (start == IntervalParser.Precision.DAY) {
            if (end == null) {
                return Period.days((int)value);
            }
            if (end == IntervalParser.Precision.HOUR) {
                return Period.hours((int)value);
            }
            if (end == IntervalParser.Precision.MINUTE) {
                return Period.minutes((int)value);
            }
            if (end == IntervalParser.Precision.SECOND) {
                return NumericalIntervalParser.buildSecondsWithMillisPeriod(value, millis);
            }
        }
        if (start == IntervalParser.Precision.HOUR) {
            if (end == null) {
                return Period.hours((int)value);
            }
            if (end == IntervalParser.Precision.MINUTE) {
                return Period.minutes((int)value);
            }
            if (end == IntervalParser.Precision.SECOND) {
                return NumericalIntervalParser.buildSecondsWithMillisPeriod(value, millis);
            }
        }
        if (start == IntervalParser.Precision.MINUTE) {
            if (end == null) {
                return Period.minutes((int)value);
            }
            if (end == IntervalParser.Precision.SECOND) {
                return Period.seconds((int)value);
            }
        }
        if (start == IntervalParser.Precision.SECOND && end == null) {
            return NumericalIntervalParser.buildSecondsWithMillisPeriod(value, millis);
        }
        throw new IllegalArgumentException("Invalid start and end combination");
    }

    private static int parseInteger(String value) {
        BigInteger result = new BigDecimal(value).toBigInteger();
        if (result.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0 || result.compareTo(BigInteger.valueOf(Integer.MIN_VALUE)) < 0) {
            throw new ArithmeticException("Interval field value out of range " + value);
        }
        return result.intValue();
    }

    private static Period buildSecondsWithMillisPeriod(int seconds, int millis) {
        Period period = Period.seconds((int)seconds);
        if (millis != 0) {
            period = period.withMillis(millis);
        }
        return period;
    }
}

