/*
 * Decompiled with CFR 0.152.
 */
package io.crate.lucene;

import org.apache.lucene.queries.CommonTermsQuery;
import org.apache.lucene.search.BooleanClause;
import org.elasticsearch.common.lucene.search.Queries;

public class ExtendedCommonTermsQuery
extends CommonTermsQuery {
    private String lowFreqMinNumShouldMatchSpec;
    private String highFreqMinNumShouldMatchSpec;

    public ExtendedCommonTermsQuery(BooleanClause.Occur highFreqOccur, BooleanClause.Occur lowFreqOccur, float maxTermFrequency) {
        super(highFreqOccur, lowFreqOccur, maxTermFrequency);
    }

    protected int calcLowFreqMinimumNumberShouldMatch(int numOptional) {
        return this.calcMinimumNumberShouldMatch(this.lowFreqMinNumShouldMatchSpec, numOptional);
    }

    protected int calcMinimumNumberShouldMatch(String spec, int numOptional) {
        if (spec == null) {
            return 0;
        }
        return Queries.calculateMinShouldMatch(numOptional, spec);
    }

    protected int calcHighFreqMinimumNumberShouldMatch(int numOptional) {
        return this.calcMinimumNumberShouldMatch(this.highFreqMinNumShouldMatchSpec, numOptional);
    }

    public void setHighFreqMinimumNumberShouldMatch(String spec) {
        this.highFreqMinNumShouldMatchSpec = spec;
    }

    public String getHighFreqMinimumNumberShouldMatchSpec() {
        return this.highFreqMinNumShouldMatchSpec;
    }

    public void setLowFreqMinimumNumberShouldMatch(String spec) {
        this.lowFreqMinNumShouldMatchSpec = spec;
    }

    public String getLowFreqMinimumNumberShouldMatchSpec() {
        return this.lowFreqMinNumShouldMatchSpec;
    }

    public float getMaxTermFrequency() {
        return this.maxTermFrequency;
    }
}

