/*
 * Decompiled with CFR 0.152.
 */
package io.crate.lucene.match;

import io.crate.lucene.match.CrateRegexTermsEnum;
import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.FilteredTermsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.util.AttributeSource;

public class CrateRegexQuery
extends MultiTermQuery {
    private final Term term;
    private final int flags;

    public CrateRegexQuery(Term term) {
        super(term.field(), MultiTermQuery.CONSTANT_SCORE_REWRITE);
        this.term = term;
        this.flags = 0;
    }

    public CrateRegexQuery(Term term, int flags) {
        super(term.field(), MultiTermQuery.CONSTANT_SCORE_REWRITE);
        this.term = term;
        this.flags = flags;
    }

    protected FilteredTermsEnum getTermsEnum(Terms terms, AttributeSource atts) throws IOException {
        return new CrateRegexTermsEnum(terms.iterator(), this.term, this.flags);
    }

    public String toString(String field) {
        StringBuilder buffer = new StringBuilder();
        if (!this.term.field().equals(field)) {
            buffer.append(this.term.field());
            buffer.append(":");
        }
        buffer.append(this.term.text());
        buffer.append(",flags:").append(this.flags);
        return buffer.toString();
    }

    public void visit(QueryVisitor visitor) {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CrateRegexQuery query = (CrateRegexQuery)((Object)o);
        return this.flags == query.flags && Objects.equals(this.term, query.term);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.term, this.flags);
    }
}

