/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.common.io.stream.StreamInput;

public enum IndexType {
    FULLTEXT,
    PLAIN,
    NONE;

    private static final List<IndexType> VALUES;

    static IndexType fromStream(StreamInput in) throws IOException {
        return VALUES.get(in.readVInt());
    }

    public static IndexType of(String indexMethod) {
        return switch (indexMethod.toLowerCase(Locale.ENGLISH)) {
            case "fulltext" -> FULLTEXT;
            case "off" -> NONE;
            case "plain" -> PLAIN;
            default -> PLAIN;
        };
    }

    static {
        VALUES = List.of(IndexType.values());
    }
}

