/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata;

import io.crate.analyze.relations.RelationAnalyzer;
import io.crate.metadata.Functions;
import io.crate.metadata.Schemas;
import io.crate.metadata.SystemClock;
import io.crate.metadata.blob.BlobSchemaInfo;
import io.crate.metadata.blob.BlobTableInfoFactory;
import io.crate.metadata.doc.DocSchemaInfoFactory;
import io.crate.metadata.doc.DocTableInfoFactory;
import io.crate.metadata.information.InformationSchemaInfo;
import io.crate.metadata.pgcatalog.PgCatalogSchemaInfo;
import io.crate.metadata.sys.SysSchemaInfo;
import io.crate.metadata.table.SchemaInfo;
import io.crate.metadata.view.ViewInfoFactory;
import io.crate.role.Roles;
import io.crate.statistics.TableStats;
import java.util.Map;
import java.util.function.Function;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.env.Environment;

public class NodeContext {
    private final Functions functions;
    private final long serverStartTimeInMs;
    private final Roles roles;
    private final Schemas schemas;
    private final TableStats tableStats;

    public static NodeContext of(Environment environment, ClusterService clusterService, Functions functions, Roles roles, TableStats tableStats) {
        return new NodeContext(functions, roles, nodeCtx -> {
            DocTableInfoFactory tableInfoFactory = new DocTableInfoFactory((NodeContext)nodeCtx);
            BlobSchemaInfo blobSchemaInfo = new BlobSchemaInfo(clusterService, new BlobTableInfoFactory(clusterService.getSettings(), environment));
            Map<String, SchemaInfo> systemSchemas = Map.of("sys", new SysSchemaInfo(clusterService, nodeCtx.roles()), "information_schema", new InformationSchemaInfo(), "pg_catalog", new PgCatalogSchemaInfo(tableStats, nodeCtx.roles()), "blob", blobSchemaInfo);
            RelationAnalyzer relationAnalyzer = new RelationAnalyzer((NodeContext)nodeCtx);
            ViewInfoFactory viewInfoFactory = new ViewInfoFactory(relationAnalyzer);
            Schemas schemas = new Schemas(systemSchemas, clusterService, new DocSchemaInfoFactory(tableInfoFactory, viewInfoFactory), nodeCtx.roles());
            schemas.start();
            return schemas;
        }, tableStats);
    }

    public NodeContext(Functions functions, Roles roles, Function<NodeContext, Schemas> createSchemas, TableStats tableStats) {
        this.functions = functions;
        this.serverStartTimeInMs = SystemClock.currentInstant().toEpochMilli();
        this.roles = roles;
        this.schemas = createSchemas.apply(this);
        this.tableStats = tableStats;
    }

    public Functions functions() {
        return this.functions;
    }

    public long serverStartTimeInMs() {
        return this.serverStartTimeInMs;
    }

    public Roles roles() {
        return this.roles;
    }

    public Schemas schemas() {
        return this.schemas;
    }

    public TableStats tableStats() {
        return this.tableStats;
    }
}

