/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public final class SearchPath
implements Iterable<String>,
Writeable {
    private static final SearchPath PG_CATALOG_AND_DOC_PATH = new SearchPath();
    private final boolean pgCatalogIsSetExplicitly;
    private final List<String> searchPath;

    public static SearchPath createSearchPathFrom(String ... schemas) {
        if (schemas == null || schemas.length == 0) {
            return new SearchPath();
        }
        return new SearchPath(List.of(schemas));
    }

    public static SearchPath pathWithPGCatalogAndDoc() {
        return PG_CATALOG_AND_DOC_PATH;
    }

    public static SearchPath createSearchPathFrom(StreamInput in) throws IOException {
        boolean pgCatalogIsSetExplicitly = in.readBoolean();
        List<String> searchPath = in.readList(StreamInput::readString);
        return new SearchPath(pgCatalogIsSetExplicitly, searchPath);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.pgCatalogIsSetExplicitly);
        out.writeStringCollection(this.searchPath);
    }

    private SearchPath() {
        this.pgCatalogIsSetExplicitly = false;
        this.searchPath = List.of("pg_catalog", "doc");
    }

    private SearchPath(boolean pgCatalogIsSetExplicitly, List<String> searchPath) {
        this.pgCatalogIsSetExplicitly = pgCatalogIsSetExplicitly;
        this.searchPath = searchPath;
    }

    private SearchPath(List<String> schemas) {
        assert (schemas.size() > 0) : "Expecting at least one schema in the search path";
        this.pgCatalogIsSetExplicitly = schemas.contains("pg_catalog");
        if (this.pgCatalogIsSetExplicitly) {
            this.searchPath = schemas;
        } else {
            ArrayList<String> completeSearchPath = new ArrayList<String>(1 + schemas.size());
            completeSearchPath.add("pg_catalog");
            completeSearchPath.addAll(schemas);
            this.searchPath = List.copyOf(completeSearchPath);
        }
    }

    public String currentSchema() {
        if (this.pgCatalogIsSetExplicitly) {
            return this.searchPath.get(0);
        }
        return this.searchPath.get(1);
    }

    public Iterable<String> showPath() {
        if (this.pgCatalogIsSetExplicitly) {
            return this.searchPath;
        }
        return this.searchPath.subList(1, this.searchPath.size());
    }

    @Override
    public Iterator<String> iterator() {
        return this.searchPath.iterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchPath that = (SearchPath)o;
        return this.pgCatalogIsSetExplicitly == that.pgCatalogIsSetExplicitly && Objects.equals(this.searchPath, that.searchPath);
    }

    public int hashCode() {
        return Objects.hash(this.pgCatalogIsSetExplicitly, this.searchPath);
    }
}

