/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata;

import io.crate.expression.scalar.cast.CastMode;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolType;
import io.crate.expression.symbol.SymbolVisitor;
import io.crate.expression.symbol.format.Style;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.FunctionType;
import io.crate.metadata.IndexType;
import io.crate.metadata.Reference;
import io.crate.metadata.ReferenceIdent;
import io.crate.metadata.RowGranularity;
import io.crate.sql.tree.ColumnPolicy;
import io.crate.types.ArrayType;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.ObjectType;
import io.crate.types.StorageSupport;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.jetbrains.annotations.Nullable;

public class SimpleReference
implements Reference {
    private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(SimpleReference.class);
    protected DataType<?> type;
    protected final int position;
    protected final long oid;
    protected boolean isDropped;
    protected final ReferenceIdent ident;
    protected final RowGranularity granularity;
    protected final IndexType indexType;
    protected final boolean nullable;
    protected final boolean hasDocValues;
    @Nullable
    protected final Symbol defaultExpression;

    public SimpleReference(StreamInput in) throws IOException {
        Integer pos;
        this.ident = new ReferenceIdent(in);
        this.position = in.getVersion().before(Version.V_4_6_0) ? ((pos = in.readOptionalVInt()) == null ? 0 : pos) : in.readVInt();
        if (in.getVersion().onOrAfter(Version.V_5_5_0)) {
            this.oid = in.readLong();
            this.isDropped = in.readBoolean();
        } else {
            this.oid = Metadata.COLUMN_OID_UNASSIGNED;
            this.isDropped = false;
        }
        this.type = DataTypes.fromStream(in);
        this.granularity = RowGranularity.fromStream(in);
        if (in.getVersion().before(Version.V_5_10_0)) {
            ColumnPolicy columnPolicy = (ColumnPolicy)ColumnPolicy.VALUES.get(in.readVInt());
            int dimensions = ArrayType.dimensions(this.type);
            DataType<?> dataType = ArrayType.unnest(this.type);
            if (dataType instanceof ObjectType) {
                ObjectType objectType = (ObjectType)dataType;
                ObjectType.Builder builder = ObjectType.of(columnPolicy);
                for (Map.Entry<String, DataType<?>> innerType : objectType.innerTypes().entrySet()) {
                    builder.setInnerType(innerType.getKey(), innerType.getValue());
                }
                this.type = ArrayType.makeArray(builder.build(), dimensions);
            }
        }
        this.indexType = IndexType.fromStream(in);
        this.nullable = in.readBoolean();
        this.hasDocValues = !in.readBoolean();
        boolean hasDefaultExpression = in.readBoolean();
        this.defaultExpression = hasDefaultExpression ? Symbol.fromStream(in) : null;
    }

    public SimpleReference(ReferenceIdent ident, RowGranularity granularity, DataType<?> type, int position, @Nullable Symbol defaultExpression) {
        this(ident, granularity, type, IndexType.PLAIN, true, false, position, Metadata.COLUMN_OID_UNASSIGNED, false, defaultExpression);
    }

    public SimpleReference(ReferenceIdent ident, RowGranularity granularity, DataType<?> type, IndexType indexType, boolean nullable, boolean hasDocValues, int position, long oid, boolean isDropped, @Nullable Symbol defaultExpression) {
        this.position = position;
        this.ident = ident;
        this.type = type;
        this.granularity = granularity;
        this.indexType = indexType;
        this.nullable = nullable;
        this.hasDocValues = hasDocValues;
        this.oid = oid;
        this.isDropped = isDropped;
        if (defaultExpression == null) {
            this.defaultExpression = null;
        } else {
            if (defaultExpression.hasFunctionType(FunctionType.TABLE)) {
                throw new UnsupportedOperationException("Cannot use table function in default expression of column `" + ident.columnIdent().fqn() + "`");
            }
            this.defaultExpression = defaultExpression.cast(type, new CastMode[0]);
        }
    }

    @Override
    public Reference withReferenceIdent(ReferenceIdent newIdent) {
        return new SimpleReference(newIdent, this.granularity, this.type, this.indexType, this.nullable, this.hasDocValues, this.position, this.oid, this.isDropped, this.defaultExpression);
    }

    @Override
    public Reference withOidAndPosition(LongSupplier acquireOid, IntSupplier acquirePosition) {
        int newPosition;
        long newOid = this.oid == Metadata.COLUMN_OID_UNASSIGNED ? acquireOid.getAsLong() : this.oid;
        int n = newPosition = this.position < 0 ? acquirePosition.getAsInt() : this.position;
        if (newOid == this.oid && newPosition == this.position) {
            return this;
        }
        return new SimpleReference(this.ident, this.granularity, this.type, this.indexType, this.nullable, this.hasDocValues, newPosition, newOid, this.isDropped, this.defaultExpression);
    }

    @Override
    public Reference withDropped(boolean dropped) {
        return new SimpleReference(this.ident, this.granularity, this.type, this.indexType, this.nullable, this.hasDocValues, this.position, this.oid, dropped, this.defaultExpression);
    }

    @Override
    public Reference withValueType(DataType<?> newType) {
        return new SimpleReference(this.ident, this.granularity, newType, this.indexType, this.nullable, this.hasDocValues, this.position, this.oid, this.isDropped, this.defaultExpression);
    }

    @Override
    public SymbolType symbolType() {
        return SymbolType.REFERENCE;
    }

    @Override
    public <C, R> R accept(SymbolVisitor<C, R> visitor, C context) {
        return visitor.visitReference(this, context);
    }

    @Override
    public DataType<?> valueType() {
        return this.type;
    }

    public String toString() {
        return this.toString(Style.UNQUALIFIED);
    }

    @Override
    public String toString(Style style) {
        if (style == Style.QUALIFIED) {
            return this.ident.tableIdent().sqlFqn() + "." + this.column().quotedOutputName();
        }
        return this.column().quotedOutputName();
    }

    @Override
    public ReferenceIdent ident() {
        return this.ident;
    }

    @Override
    public ColumnIdent column() {
        return this.ident.columnIdent();
    }

    @Override
    public RowGranularity granularity() {
        return this.granularity;
    }

    @Override
    public IndexType indexType() {
        return this.indexType;
    }

    @Override
    public boolean isNullable() {
        return this.nullable;
    }

    @Override
    public boolean hasDocValues() {
        return this.hasDocValues;
    }

    @Override
    public int position() {
        return this.position;
    }

    @Override
    public long oid() {
        return this.oid;
    }

    @Override
    public boolean isDropped() {
        return this.isDropped;
    }

    @Override
    @Nullable
    public Symbol defaultExpression() {
        return this.defaultExpression;
    }

    @Override
    public boolean isGenerated() {
        return false;
    }

    @Override
    public Map<String, Object> toMapping(int position) {
        boolean docValuesDefault;
        StorageSupport<?> storageSupport;
        DataType<?> innerType = ArrayType.unnest(this.type);
        HashMap<String, Object> mapping = new HashMap<String, Object>();
        mapping.put("type", DataTypes.esMappingNameFrom(innerType.id()));
        mapping.put("position", position);
        if (this.oid != Metadata.COLUMN_OID_UNASSIGNED) {
            mapping.put("oid", this.oid);
        }
        if (this.isDropped) {
            mapping.put("dropped", true);
        }
        if (this.indexType == IndexType.NONE && this.type.id() != 12) {
            mapping.put("index", false);
        }
        if ((storageSupport = innerType.storageSupport()) != null && (docValuesDefault = storageSupport.getComputedDocValuesDefault(this.indexType)) != this.hasDocValues) {
            mapping.put("doc_values", Boolean.toString(this.hasDocValues));
        }
        if (this.defaultExpression != null) {
            mapping.put("default_expr", this.defaultExpression.toString(Style.UNQUALIFIED));
        }
        innerType.addMappingOptions(mapping);
        return mapping;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleReference reference = (SimpleReference)o;
        if (this.nullable != reference.nullable) {
            return false;
        }
        if (this.hasDocValues != reference.hasDocValues) {
            return false;
        }
        if (!this.type.equals(reference.type)) {
            return false;
        }
        if (!Objects.equals(this.position, reference.position)) {
            return false;
        }
        if (!this.ident.equals(reference.ident)) {
            return false;
        }
        if (this.granularity != reference.granularity) {
            return false;
        }
        if (this.indexType != reference.indexType) {
            return false;
        }
        if (this.oid != reference.oid) {
            return false;
        }
        if (this.isDropped != reference.isDropped()) {
            return false;
        }
        return Objects.equals(this.defaultExpression, reference.defaultExpression);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + Integer.hashCode(this.position);
        result = 31 * result + this.ident.hashCode();
        result = 31 * result + this.granularity.hashCode();
        result = 31 * result + this.indexType.hashCode();
        result = 31 * result + (this.nullable ? 1 : 0);
        result = 31 * result + (this.hasDocValues ? 1 : 0);
        result = 31 * result + Long.hashCode(this.oid);
        result = 31 * result + Boolean.hashCode(this.isDropped);
        result = 31 * result + (this.defaultExpression != null ? this.defaultExpression.hashCode() : 0);
        return result;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.ident.writeTo(out);
        if (out.getVersion().before(Version.V_4_6_0)) {
            out.writeOptionalVInt(this.position);
        } else {
            out.writeVInt(this.position);
        }
        if (out.getVersion().onOrAfter(Version.V_5_5_0)) {
            out.writeLong(this.oid);
            out.writeBoolean(this.isDropped);
        }
        DataTypes.toStream(this.type, out);
        RowGranularity.toStream(this.granularity, out);
        if (out.getVersion().before(Version.V_5_10_0)) {
            out.writeVInt(this.valueType().columnPolicy().ordinal());
        }
        out.writeVInt(this.indexType.ordinal());
        out.writeBoolean(this.nullable);
        out.writeBoolean(!this.hasDocValues);
        Symbol.nullableToStream(this.defaultExpression, out);
    }

    public long ramBytesUsed() {
        return SHALLOW_SIZE + this.type.ramBytesUsed() + this.ident.ramBytesUsed() + (this.defaultExpression == null ? 0L : this.defaultExpression.ramBytesUsed());
    }
}

