/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.cluster;

import io.crate.execution.ddl.index.SwapAndDropIndexRequest;
import io.crate.metadata.cluster.DDLClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.allocation.AllocationService;

public class SwapAndDropIndexExecutor
extends DDLClusterStateTaskExecutor<SwapAndDropIndexRequest> {
    private final AllocationService allocationService;

    public SwapAndDropIndexExecutor(AllocationService allocationService) {
        this.allocationService = allocationService;
    }

    @Override
    public ClusterState execute(ClusterState currentState, SwapAndDropIndexRequest request) throws Exception {
        Metadata metadata = currentState.metadata();
        ClusterBlocks.Builder blocksBuilder = ClusterBlocks.builder().blocks(currentState.blocks());
        Metadata.Builder mdBuilder = Metadata.builder(metadata);
        RoutingTable.Builder routingBuilder = RoutingTable.builder(currentState.routingTable());
        String sourceIndexName = request.source();
        String targetIndexName = request.target();
        mdBuilder.remove(sourceIndexName);
        mdBuilder.remove(targetIndexName);
        routingBuilder.remove(sourceIndexName);
        routingBuilder.remove(targetIndexName);
        blocksBuilder.removeIndexBlocks(sourceIndexName);
        blocksBuilder.removeIndexBlocks(targetIndexName);
        IndexMetadata sourceIndex = metadata.index(sourceIndexName);
        if (sourceIndex == null) {
            throw new IllegalArgumentException("Source index must exist: " + sourceIndexName);
        }
        IndexRoutingTable index = currentState.routingTable().index(sourceIndex.getIndex());
        if (!index.allPrimaryShardsActive()) {
            throw new UnsupportedOperationException("Cannot swap and drop index if source '" + sourceIndexName + "' has unallocated primaries");
        }
        IndexMetadata newIndexMetadata = IndexMetadata.builder(sourceIndex).index(targetIndexName).build();
        mdBuilder.put(newIndexMetadata, true);
        routingBuilder.addAsFromCloseToOpen(newIndexMetadata);
        blocksBuilder.addBlocks(newIndexMetadata);
        return this.allocationService.reroute(ClusterState.builder(currentState).metadata(mdBuilder).routingTable(routingBuilder.build()).blocks(blocksBuilder).build(), "swap and drop index");
    }
}

