/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.information;

import io.crate.expression.reference.information.ColumnContext;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.GeneratedReference;
import io.crate.metadata.RelationName;
import io.crate.metadata.SystemTable;
import io.crate.types.DataType;
import io.crate.types.DataTypes;

public class InformationColumnsTableInfo {
    public static final String NAME = "columns";
    public static final RelationName IDENT = new RelationName("information_schema", "columns");
    private static final String IS_GENERATED_NEVER = "NEVER";
    private static final String IS_GENERATED_ALWAYS = "ALWAYS";
    private static final Integer NUMERIC_PRECISION_RADIX = 2;
    private static final Integer DATETIME_PRECISION = 3;
    public static SystemTable<ColumnContext> INSTANCE = ((SystemTable.RelationBuilder)((SystemTable.ObjectBuilder)((SystemTable.ObjectBuilder)((SystemTable.ObjectBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)SystemTable.builder(IDENT).addNonNull("table_schema", DataTypes.STRING, r -> r.ref().ident().tableIdent().schema()).addNonNull("table_name", DataTypes.STRING, r -> r.ref().ident().tableIdent().name()).addNonNull("table_catalog", DataTypes.STRING, r -> "crate").addNonNull("column_name", DataTypes.STRING, r -> r.ref().column().sqlFqn()).addNonNull("ordinal_position", DataTypes.INTEGER, r -> r.ref().position()).addNonNull("data_type", DataTypes.STRING, r -> r.ref().valueType().getName()).addNonNull("is_generated", DataTypes.STRING, r -> {
        if (r.ref() instanceof GeneratedReference) {
            return IS_GENERATED_ALWAYS;
        }
        return IS_GENERATED_NEVER;
    }).addNonNull("is_nullable", DataTypes.BOOLEAN, r -> !r.relation().primaryKey().contains(r.ref().column()) && r.ref().isNullable()).add("generation_expression", (DataType)DataTypes.STRING, r -> {
        if (r.ref() instanceof GeneratedReference) {
            return ((GeneratedReference)r.ref()).formattedGeneratedExpression();
        }
        return null;
    })).add("column_default", (DataType)DataTypes.STRING, r -> {
        Symbol defaultExpression = r.ref().defaultExpression();
        if (defaultExpression != null) {
            return defaultExpression.toString();
        }
        return null;
    })).add("character_maximum_length", (DataType)DataTypes.INTEGER, r -> r.ref().valueType().characterMaximumLength())).add("character_octet_length", (DataType)DataTypes.INTEGER, ignored -> null)).add("numeric_precision", (DataType)DataTypes.INTEGER, r -> r.ref().valueType().numericPrecision())).add("numeric_precision_radix", (DataType)DataTypes.INTEGER, r -> {
        if (DataTypes.isNumericPrimitive(r.ref().valueType())) {
            return NUMERIC_PRECISION_RADIX;
        }
        return null;
    })).add("numeric_scale", (DataType)DataTypes.INTEGER, ignored -> null)).add("datetime_precision", (DataType)DataTypes.INTEGER, r -> {
        if (r.ref().valueType() == DataTypes.TIMESTAMPZ || r.ref().valueType() == DataTypes.TIMESTAMP) {
            return DATETIME_PRECISION;
        }
        return null;
    })).add("interval_type", (DataType)DataTypes.STRING, ignored -> null)).add("interval_precision", (DataType)DataTypes.INTEGER, ignored -> null)).add("character_set_catalog", (DataType)DataTypes.STRING, ignored -> null)).add("character_set_schema", (DataType)DataTypes.STRING, ignored -> null)).add("character_set_name", (DataType)DataTypes.STRING, ignored -> null)).add("collation_catalog", (DataType)DataTypes.STRING, ignored -> null)).add("collation_schema", (DataType)DataTypes.STRING, ignored -> null)).add("collation_name", (DataType)DataTypes.STRING, ignored -> null)).add("domain_catalog", (DataType)DataTypes.STRING, ignored -> null)).add("domain_schema", (DataType)DataTypes.STRING, ignored -> null)).add("domain_name", (DataType)DataTypes.STRING, ignored -> null)).add("udt_catalog", (DataType)DataTypes.STRING, ignored -> null)).add("udt_schema", (DataType)DataTypes.STRING, ignored -> null)).add("udt_name", (DataType)DataTypes.STRING, ignored -> null)).add("is_identity", (DataType)DataTypes.BOOLEAN, ignored -> false)).add("identity_generation", (DataType)DataTypes.STRING, ignored -> null)).add("identity_start", (DataType)DataTypes.STRING, ignored -> null)).add("identity_increment", (DataType)DataTypes.STRING, ignored -> null)).add("identity_maximum", (DataType)DataTypes.STRING, ignored -> null)).add("identity_minimum", (DataType)DataTypes.STRING, ignored -> null)).add("identity_cycle", (DataType)DataTypes.BOOLEAN, ignored -> null)).add("check_references", (DataType)DataTypes.STRING, ignored -> null)).add("check_action", (DataType)DataTypes.INTEGER, ignored -> null)).startObject("column_details").add("name", (DataType)DataTypes.STRING, r -> r.ref().column().name())).add("path", DataTypes.STRING_ARRAY, r -> r.ref().column().path())).add("policy", (DataType)DataTypes.STRING, r -> r.ref().valueType().columnPolicy().lowerCaseName())).endObject()).setPrimaryKeys(ColumnIdent.of("table_catalog"), ColumnIdent.of("table_name"), ColumnIdent.of("table_schema"), ColumnIdent.of("column_name")).build();
}

