/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.information;

import io.crate.common.collections.Lists;
import io.crate.common.unit.TimeValue;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.RelationInfo;
import io.crate.metadata.RelationName;
import io.crate.metadata.SystemTable;
import io.crate.metadata.blob.BlobTableInfo;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.table.ShardedTable;
import io.crate.metadata.table.StoredTable;
import io.crate.sql.tree.ColumnPolicy;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.elasticsearch.Version;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.cluster.routing.allocation.decider.EnableAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.ShardsLimitAllocationDecider;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.index.IndexModule;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.MergeSchedulerConfig;
import org.elasticsearch.index.engine.EngineConfig;

public class InformationTablesTableInfo {
    public static final String NAME = "tables";
    public static final RelationName IDENT = new RelationName("information_schema", "tables");
    private static final String SELF_REFERENCING_COLUMN_NAME = "_id";
    private static final String REFERENCE_GENERATION = "SYSTEM GENERATED";
    public static SystemTable<RelationInfo> INSTANCE = ((SystemTable.RelationBuilder)((SystemTable.ObjectBuilder)((SystemTable.ObjectBuilder)((SystemTable.ObjectBuilder)((SystemTable.ObjectBuilder)((SystemTable.ObjectBuilder)((SystemTable.ObjectBuilder)((SystemTable.ObjectBuilder)((SystemTable.ObjectBuilder)((SystemTable.ObjectBuilder)((SystemTable.ObjectBuilder)((SystemTable.ObjectBuilder)((SystemTable.ObjectBuilder)((SystemTable.ObjectBuilder)((SystemTable.ObjectBuilder)((SystemTable.ObjectBuilder)((SystemTable.ObjectBuilder)((SystemTable.ObjectBuilder)((SystemTable.ObjectBuilder)((SystemTable.ObjectBuilder)((SystemTable.ObjectBuilder)((SystemTable.ObjectBuilder)((SystemTable.ObjectBuilder)((SystemTable.ObjectBuilder)((SystemTable.ObjectBuilder)((SystemTable.ObjectBuilder)((SystemTable.ObjectBuilder)((SystemTable.ObjectBuilder)((SystemTable.ObjectBuilder)((SystemTable.ObjectBuilder)((SystemTable.ObjectBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.ObjectBuilder)((SystemTable.ObjectBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)SystemTable.builder(IDENT).add("table_schema", (DataType)DataTypes.STRING, r -> r.ident().schema())).add("table_name", (DataType)DataTypes.STRING, r -> r.ident().name())).add("table_catalog", (DataType)DataTypes.STRING, r -> "crate")).add("table_type", (DataType)DataTypes.STRING, r -> r.relationType().pretty())).add("number_of_shards", (DataType)DataTypes.INTEGER, row -> {
        if (row instanceof ShardedTable) {
            return ((ShardedTable)((Object)row)).numberOfShards();
        }
        return null;
    })).add("number_of_replicas", (DataType)DataTypes.STRING, row -> {
        if (row instanceof ShardedTable) {
            return ((ShardedTable)((Object)row)).numberOfReplicas();
        }
        return null;
    })).add("clustered_by", (DataType)DataTypes.STRING, row -> {
        if (row instanceof ShardedTable) {
            ColumnIdent clusteredBy = ((ShardedTable)((Object)row)).clusteredBy();
            if (clusteredBy == null) {
                return null;
            }
            return clusteredBy.fqn();
        }
        return null;
    })).add("partitioned_by", DataTypes.STRING_ARRAY, row -> {
        if (row instanceof DocTableInfo) {
            List<ColumnIdent> partitionedBy = ((DocTableInfo)row).partitionedBy();
            if (partitionedBy == null || partitionedBy.isEmpty()) {
                return null;
            }
            return Lists.map(partitionedBy, ColumnIdent::sqlFqn);
        }
        return null;
    })).add("blobs_path", (DataType)DataTypes.STRING, row -> {
        if (row instanceof BlobTableInfo) {
            return ((BlobTableInfo)row).blobsPath();
        }
        return null;
    })).add("column_policy", (DataType)DataTypes.STRING, row -> {
        if (row instanceof DocTableInfo) {
            return ((DocTableInfo)row).columnPolicy().lowerCaseName();
        }
        return ColumnPolicy.STRICT.lowerCaseName();
    })).add("routing_hash_function", (DataType)DataTypes.STRING, row -> {
        if (row instanceof ShardedTable) {
            return "Murmur3";
        }
        return null;
    })).startObject("version", x -> !(x instanceof ShardedTable)).add(Version.Property.CREATED.toString(), (DataType)DataTypes.STRING, x -> {
        if (x instanceof StoredTable) {
            Version version = ((StoredTable)((Object)x)).versionCreated();
            return version == null ? null : version.externalNumber();
        }
        return null;
    })).add(Version.Property.UPGRADED.toString(), (DataType)DataTypes.STRING, x -> {
        if (x instanceof StoredTable) {
            Version version = ((StoredTable)((Object)x)).versionUpgraded();
            return version == null ? null : version.externalNumber();
        }
        return null;
    })).endObject()).add("closed", (DataType)DataTypes.BOOLEAN, row -> {
        if (row instanceof ShardedTable) {
            return ((ShardedTable)((Object)row)).isClosed();
        }
        return null;
    })).add("reference_generation", (DataType)DataTypes.STRING, r -> "SYSTEM GENERATED")).add("self_referencing_column_name", (DataType)DataTypes.STRING, row -> {
        if (row instanceof ShardedTable) {
            return SELF_REFERENCING_COLUMN_NAME;
        }
        return null;
    })).startObject("settings", x -> !(x instanceof ShardedTable)).add("refresh_interval", (DataType)DataTypes.LONG, InformationTablesTableInfo.fromTimeValue(IndexSettings.INDEX_REFRESH_INTERVAL_SETTING))).startObject("blocks").add("read_only", (DataType)DataTypes.BOOLEAN, InformationTablesTableInfo.fromSetting(IndexMetadata.INDEX_READ_ONLY_SETTING))).add("read", (DataType)DataTypes.BOOLEAN, InformationTablesTableInfo.fromSetting(IndexMetadata.INDEX_BLOCKS_READ_SETTING))).add("write", (DataType)DataTypes.BOOLEAN, InformationTablesTableInfo.fromSetting(IndexMetadata.INDEX_BLOCKS_WRITE_SETTING))).add("metadata", (DataType)DataTypes.BOOLEAN, InformationTablesTableInfo.fromSetting(IndexMetadata.INDEX_BLOCKS_METADATA_SETTING))).add("read_only_allow_delete", (DataType)DataTypes.BOOLEAN, InformationTablesTableInfo.fromSetting(IndexMetadata.INDEX_BLOCKS_READ_ONLY_ALLOW_DELETE_SETTING))).endObject()).add("codec", (DataType)DataTypes.STRING, InformationTablesTableInfo.fromSetting(EngineConfig.INDEX_CODEC_SETTING))).startObject("store").add("type", (DataType)DataTypes.STRING, InformationTablesTableInfo.fromSetting(IndexModule.INDEX_STORE_TYPE_SETTING))).endObject()).startObject("translog").add("flush_threshold_size", (DataType)DataTypes.LONG, InformationTablesTableInfo.fromByteSize(IndexSettings.INDEX_TRANSLOG_FLUSH_THRESHOLD_SIZE_SETTING))).add("sync_interval", (DataType)DataTypes.LONG, InformationTablesTableInfo.fromTimeValue(IndexSettings.INDEX_TRANSLOG_SYNC_INTERVAL_SETTING))).add("durability", (DataType)DataTypes.STRING, InformationTablesTableInfo.fromSetting(IndexSettings.INDEX_TRANSLOG_DURABILITY_SETTING, Enum::name))).endObject()).startObject("routing").startObject("allocation").add("enable", (DataType)DataTypes.STRING, InformationTablesTableInfo.fromSetting(EnableAllocationDecider.INDEX_ROUTING_ALLOCATION_ENABLE_SETTING, EnableAllocationDecider.Allocation::toString))).add("total_shards_per_node", (DataType)DataTypes.INTEGER, InformationTablesTableInfo.fromSetting(ShardsLimitAllocationDecider.INDEX_TOTAL_SHARDS_PER_NODE_SETTING))).addDynamicObject("require", DataTypes.STRING, InformationTablesTableInfo.fromSetting(IndexMetadata.INDEX_ROUTING_REQUIRE_GROUP_SETTING)).addDynamicObject("include", DataTypes.STRING, InformationTablesTableInfo.fromSetting(IndexMetadata.INDEX_ROUTING_INCLUDE_GROUP_SETTING)).addDynamicObject("exclude", DataTypes.STRING, InformationTablesTableInfo.fromSetting(IndexMetadata.INDEX_ROUTING_EXCLUDE_GROUP_SETTING)).endObject()).endObject()).startObject("unassigned").startObject("node_left").add("delayed_timeout", (DataType)DataTypes.LONG, InformationTablesTableInfo.fromTimeValue(UnassignedInfo.INDEX_DELAYED_NODE_LEFT_TIMEOUT_SETTING))).endObject()).endObject()).startObject("mapping").startObject("total_fields").add("limit", (DataType)DataTypes.INTEGER, InformationTablesTableInfo.fromSetting(DocTableInfo.TOTAL_COLUMNS_LIMIT, DataTypes.INTEGER::sanitizeValue))).endObject()).endObject()).startObject("merge").startObject("scheduler").add("max_thread_count", (DataType)DataTypes.INTEGER, InformationTablesTableInfo.fromSetting(MergeSchedulerConfig.MAX_THREAD_COUNT_SETTING))).add("max_merge_count", (DataType)DataTypes.INTEGER, InformationTablesTableInfo.fromSetting(MergeSchedulerConfig.MAX_MERGE_COUNT_SETTING))).endObject()).endObject()).startObject("write").add("wait_for_active_shards", (DataType)DataTypes.STRING, InformationTablesTableInfo.fromSetting(IndexMetadata.SETTING_WAIT_FOR_ACTIVE_SHARDS, ActiveShardCount::toString))).endObject()).endObject()).setPrimaryKeys(ColumnIdent.of("table_catalog"), ColumnIdent.of("table_schema"), ColumnIdent.of("table_name")).build();

    private static Function<RelationInfo, Long> fromByteSize(Setting<ByteSizeValue> byteSizeSetting) {
        return rel -> {
            if (rel instanceof StoredTable) {
                return ((ByteSizeValue)byteSizeSetting.get(rel.parameters())).getBytes();
            }
            return null;
        };
    }

    private static <T> Function<RelationInfo, T> fromSetting(Setting<T> setting) {
        return rel -> {
            if (rel instanceof StoredTable) {
                return setting.get(rel.parameters());
            }
            return null;
        };
    }

    private static <T> Function<RelationInfo, Map<String, Object>> fromSetting(Setting.AffixSetting<T> setting) {
        return rel -> {
            if (rel instanceof StoredTable) {
                return setting.getAsMap(rel.parameters());
            }
            return null;
        };
    }

    private static <T, U> Function<RelationInfo, U> fromSetting(Setting<T> setting, Function<T, U> andThen) {
        return rel -> {
            if (rel instanceof StoredTable) {
                return andThen.apply(setting.get(rel.parameters()));
            }
            return null;
        };
    }

    private static Function<RelationInfo, Long> fromTimeValue(Setting<TimeValue> timeValueSetting) {
        return rel -> {
            if (rel instanceof StoredTable) {
                return ((TimeValue)timeValueSetting.get(rel.parameters())).millis();
            }
            return null;
        };
    }
}

