/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.settings;

import io.crate.common.Booleans;
import io.crate.types.DataTypes;
import java.util.Objects;
import java.util.regex.Pattern;
import org.elasticsearch.cluster.metadata.AutoExpandReplicas;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;

public class NumberOfReplicas
extends Setting<Settings> {
    private static final Pattern EXPAND_REPLICA_PATTERN = Pattern.compile("\\d+\\-(all|\\d+)");
    private static final Settings DEFAULT = Settings.builder().put("index.number_of_replicas", 0).put("index.auto_expand_replicas", AutoExpandReplicas.SETTING.getDefaultRaw(Settings.EMPTY)).build();
    public static final NumberOfReplicas SETTING = new NumberOfReplicas();

    private NumberOfReplicas() {
        super((Setting.Key)new Setting.SimpleKey("index.number_of_replicas"), (Settings s) -> "0-1", NumberOfReplicas::parseValue, DataTypes.STRING, Setting.Property.ReplicatedIndexScope);
    }

    private static Settings parseValue(String value) {
        Settings.Builder builder = Settings.builder();
        builder.put(AutoExpandReplicas.SETTING.getKey(), false);
        try {
            int numReplicas = NumberOfReplicas.parseInt(value, 0, "index.number_of_replicas");
            builder.put("index.number_of_replicas", numReplicas);
        }
        catch (NumberFormatException e) {
            NumberOfReplicas.validateExpandReplicaSetting(value);
            builder.put("index.auto_expand_replicas", value);
        }
        return builder.build();
    }

    @Override
    public Settings getDefault(Settings settings) {
        return DEFAULT;
    }

    public static String getVirtualValue(Settings settings) {
        String numberOfReplicas;
        String autoExpandReplicas = settings.get("index.auto_expand_replicas");
        if (autoExpandReplicas != null && !Booleans.isFalse((String)autoExpandReplicas)) {
            NumberOfReplicas.validateExpandReplicaSetting(autoExpandReplicas);
            numberOfReplicas = autoExpandReplicas;
        } else {
            numberOfReplicas = Objects.requireNonNullElse(settings.get("index.number_of_replicas"), "1");
        }
        return numberOfReplicas;
    }

    public static int effectiveNumReplicas(Settings settings, DiscoveryNodes nodes) {
        int numDataNodes = nodes.getDataNodes().size();
        AutoExpandReplicas autoExpandReplicas = AutoExpandReplicas.SETTING.get(settings);
        if (autoExpandReplicas.isEnabled()) {
            int min = autoExpandReplicas.getMinReplicas();
            int max = autoExpandReplicas.getMaxReplicas(numDataNodes);
            int numberOfReplicas = numDataNodes - 1;
            if (numberOfReplicas < min) {
                return min;
            }
            if (numberOfReplicas > max) {
                return max;
            }
        }
        return IndexMetadata.INDEX_NUMBER_OF_REPLICAS_SETTING.get(settings);
    }

    private static void validateExpandReplicaSetting(String replicas) {
        if (!EXPAND_REPLICA_PATTERN.matcher(replicas).matches()) {
            throw new IllegalArgumentException("The \"number_of_replicas\" range \"" + replicas + "\" isn't valid");
        }
    }
}

