/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.sys;

import io.crate.metadata.RelationName;
import io.crate.metadata.SystemTable;
import io.crate.metadata.settings.CrateSettings;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;

public class SysClusterTableInfo {
    public static final RelationName IDENT = new RelationName("sys", "cluster");

    private SysClusterTableInfo() {
    }

    public static SystemTable<Void> of(ClusterService clusterService) {
        Settings settings = clusterService.getSettings();
        ClusterSettings clusterSettings = clusterService.getClusterSettings();
        SystemTable.RelationBuilder relBuilder = (SystemTable.RelationBuilder)((SystemTable.ObjectBuilder)((SystemTable.ObjectBuilder)((SystemTable.ObjectBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)SystemTable.builder(IDENT).add("id", (DataType)DataTypes.STRING, void_ -> clusterService.state().metadata().clusterUUID())).add("name", (DataType)DataTypes.STRING, void_ -> ClusterName.CLUSTER_NAME_SETTING.get(settings).value())).add("master_node", (DataType)DataTypes.STRING, void_ -> clusterService.state().nodes().getMasterNodeId())).startObject("license", ignored -> true).add("expiry_date", (DataType)DataTypes.TIMESTAMPZ, ignored -> null)).add("issued_to", (DataType)DataTypes.STRING, ignored -> null)).add("max_nodes", (DataType)DataTypes.INTEGER, ignored -> null)).endObject();
        SystemTable.ObjectBuilder settingsBuilder = (SystemTable.ObjectBuilder)((SystemTable.ObjectArrayBuilder)((SystemTable.ObjectArrayBuilder)relBuilder.startObject("settings").startObjectArray("logger", SysClusterTableInfo.extractLoggers(clusterSettings)).add("name", (DataType)DataTypes.STRING, LoggerEntry::loggerName)).add("level", (DataType)DataTypes.STRING, LoggerEntry::level)).endObjectArray();
        Node<Setting<?>> rootNode = SysClusterTableInfo.toTree();
        for (Node<Setting<?>> node : rootNode.children) {
            SysClusterTableInfo.addSetting(clusterSettings, settingsBuilder, node);
        }
        return ((SystemTable.RelationBuilder)settingsBuilder.endObject()).build();
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void addSetting(ClusterSettings clusterSettings, SystemTable.ObjectBuilder<Void, ? extends SystemTable.Builder<Void>> settingsBuilder, Node<Setting<?>> element) {
        if (element instanceof Leaf) {
            Leaf leaf = (Leaf)element;
            Setting setting = (Setting)leaf.value;
            DataType<?> dataType = ((Setting)leaf.value).dataType();
            Object settingValue = clusterSettings.get(setting);
            if (settingValue instanceof Settings) {
                Settings groupSetting = (Settings)settingValue;
                if (dataType.id() == 12) {
                    settingsBuilder.addDynamicObject(leaf.name, DataTypes.STRING, void_ -> groupSetting.getAsStructuredMap());
                    return;
                }
            }
            settingsBuilder.add(leaf.name, dataType, void_ -> dataType.implicitCast(clusterSettings.get(setting)));
            return;
        }
        SystemTable.ObjectBuilder<Void, SystemTable.ObjectBuilder<Void, ? extends SystemTable.Builder<Void>>> objectSetting = settingsBuilder.startObject(element.name);
        Iterator iterator = element.children.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                objectSetting.endObject();
                return;
            }
            Node<Setting<?>> node = iterator.next();
            SysClusterTableInfo.addSetting(clusterSettings, objectSetting, node);
        }
    }

    private static Function<Void, List<LoggerEntry>> extractLoggers(ClusterSettings clusterSettings) {
        return void_ -> {
            ArrayList<LoggerEntry> loggers = new ArrayList<LoggerEntry>();
            Settings loggerSettings = clusterSettings.getLoggerSettings();
            for (String settingName : loggerSettings.keySet()) {
                loggers.add(new LoggerEntry(settingName, loggerSettings.get(settingName).toUpperCase(Locale.ENGLISH)));
            }
            return loggers;
        };
    }

    private static Node<Setting<?>> toTree() {
        Node rootNode = new Node("root");
        for (Setting<?> setting : CrateSettings.EXPOSED_SETTINGS) {
            rootNode.add(setting.path(), setting);
        }
        return rootNode;
    }

    private static class Node<T> {
        final String name;
        private final ArrayList<Node<T>> children = new ArrayList();

        private Node(String name) {
            this.name = name;
        }

        private void add(List<String> path, T value) {
            switch (path.size()) {
                case 0: {
                    throw new IllegalArgumentException("Path must not be empty");
                }
                case 1: {
                    this.children.add(new Leaf<T>(path.get(0), value));
                    break;
                }
                default: {
                    String valueName = path.get(0);
                    for (Node<T> child : this.children) {
                        if (!child.name.equals(valueName)) continue;
                        child.add(path.subList(1, path.size()), value);
                        return;
                    }
                    Node<T> newChild = new Node<T>(valueName);
                    this.children.add(newChild);
                    newChild.add(path.subList(1, path.size()), value);
                }
            }
        }
    }

    private static class Leaf<T>
    extends Node<T> {
        private final T value;

        private Leaf(String name, T value) {
            super(name);
            this.value = value;
        }
    }

    public record LoggerEntry(String loggerName, String level) {
    }
}

