/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.table;

import io.crate.expression.symbol.Symbol;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationInfo;
import io.crate.metadata.RelationName;
import io.crate.metadata.table.TableInfo;
import java.util.ArrayList;
import java.util.List;

public class ConstraintInfo {
    private final String constraintName;
    private final List<Short> conkey;
    private final RelationInfo relationInfo;
    private final Type constraintType;

    public ConstraintInfo(RelationInfo relationInfo, String constraintName, Type constraintType) {
        this.relationInfo = relationInfo;
        this.constraintName = constraintName;
        this.constraintType = constraintType;
        this.conkey = ConstraintInfo.getConstraintColumnIndices(relationInfo, constraintName, constraintType);
    }

    private static List<Short> getConstraintColumnIndices(RelationInfo relationInfo, String constraintName, Type constraintType) {
        if (relationInfo instanceof TableInfo) {
            TableInfo tableInfo = (TableInfo)relationInfo;
            if (constraintType == Type.PRIMARY_KEY) {
                return relationInfo.primaryKey().stream().map(column -> (short)tableInfo.getReference((ColumnIdent)column).position()).toList();
            }
            if (constraintType == Type.CHECK) {
                return tableInfo.checkConstraints().stream().filter(checkConstraint -> checkConstraint.name().equals(constraintName)).map(checkConstraint -> {
                    ArrayList positions = new ArrayList();
                    ((Symbol)checkConstraint.expression()).visit(Reference.class, r -> positions.add((short)r.position()));
                    return positions;
                }).findFirst().orElse(List.of());
            }
        }
        return List.of();
    }

    public RelationName relationName() {
        return this.relationInfo.ident();
    }

    public RelationInfo relationInfo() {
        return this.relationInfo;
    }

    public String constraintName() {
        return this.constraintName;
    }

    public Type constraintType() {
        return this.constraintType;
    }

    public List<Short> conkey() {
        return this.conkey;
    }

    public static enum Type {
        PRIMARY_KEY("PRIMARY KEY", "p"),
        CHECK("CHECK", "c");

        private final String text;
        private final String postgresChar;

        private Type(String text, String postgresChar) {
            this.text = text;
            this.postgresChar = postgresChar;
        }

        public String toString() {
            return this.text;
        }

        public String postgresChar() {
            return this.postgresChar;
        }
    }
}

