/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.node.ddl;

import io.crate.analyze.AnalyzedAlterRole;
import io.crate.analyze.SymbolEvaluator;
import io.crate.data.Row;
import io.crate.data.Row1;
import io.crate.data.RowConsumer;
import io.crate.execution.support.OneRowActionListener;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.settings.session.SessionSettingRegistry;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.Plan;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.SubQueryResults;
import io.crate.role.JwtProperties;
import io.crate.role.Role;
import io.crate.role.RoleManager;
import io.crate.role.SecureHash;
import io.crate.sql.tree.GenericProperties;
import java.util.Map;
import java.util.function.Function;

public class AlterRolePlan
implements Plan {
    private final RoleManager roleManager;
    private final AnalyzedAlterRole alterRole;
    private final SessionSettingRegistry sessionSettingRegistry;

    public AlterRolePlan(AnalyzedAlterRole alterRole, RoleManager roleManager, SessionSettingRegistry sessionSettingRegistry) {
        this.alterRole = alterRole;
        this.roleManager = roleManager;
        this.sessionSettingRegistry = sessionSettingRegistry;
    }

    @Override
    public Plan.StatementType type() {
        return Plan.StatementType.DDL;
    }

    @Override
    public void executeOrFail(DependencyCarrier dependencies, PlannerContext plannerContext, RowConsumer consumer, Row params, SubQueryResults subQueryResults) throws Exception {
        Function<Symbol, Object> eval = x -> SymbolEvaluator.evaluate(plannerContext.transactionContext(), plannerContext.nodeContext(), x, params, subQueryResults);
        GenericProperties evaluatedProperties = this.alterRole.properties().map(eval);
        Role.Properties roleProperties = Role.Properties.of(false, this.alterRole.isReset(), (GenericProperties<Object>)evaluatedProperties, this.sessionSettingRegistry);
        SecureHash newPassword = roleProperties.password();
        boolean resetPassword = evaluatedProperties.contains("password") && newPassword == null;
        JwtProperties newJwtProperties = roleProperties.jwtProperties();
        boolean resetJwtProperties = evaluatedProperties.contains("jwt") && newJwtProperties == null;
        this.roleManager.alterRole(this.alterRole.roleName(), newPassword, newJwtProperties, resetPassword, resetJwtProperties, Map.of(this.alterRole.isReset(), roleProperties.sessionSettings())).whenComplete(new OneRowActionListener<Long>(consumer, rCount -> new Row1((Object)(rCount == null ? -1L : rCount))));
    }
}

