/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.node.ddl;

import io.crate.analyze.AnalyzedCreateSnapshot;
import io.crate.analyze.SnapshotSettings;
import io.crate.analyze.SymbolEvaluator;
import io.crate.common.collections.Lists;
import io.crate.data.Row;
import io.crate.data.Row1;
import io.crate.data.RowConsumer;
import io.crate.exceptions.CreateSnapshotException;
import io.crate.exceptions.PartitionUnknownException;
import io.crate.exceptions.ResourceUnknownException;
import io.crate.execution.support.OneRowActionListener;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.NodeContext;
import io.crate.metadata.PartitionName;
import io.crate.metadata.Schemas;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.table.Operation;
import io.crate.metadata.table.SchemaInfo;
import io.crate.metadata.table.TableInfo;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.Plan;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.SubQueryResults;
import io.crate.sql.tree.GenericProperties;
import io.crate.sql.tree.Table;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotAction;
import org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotRequest;
import org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.snapshots.SnapshotState;
import org.jetbrains.annotations.VisibleForTesting;

public class CreateSnapshotPlan
implements Plan {
    private static final Logger LOGGER = LogManager.getLogger(CreateSnapshotPlan.class);
    private final AnalyzedCreateSnapshot createSnapshot;

    public CreateSnapshotPlan(AnalyzedCreateSnapshot createSnapshot) {
        this.createSnapshot = createSnapshot;
    }

    @Override
    public Plan.StatementType type() {
        return Plan.StatementType.DDL;
    }

    @Override
    public void executeOrFail(DependencyCarrier dependencies, PlannerContext plannerContext, RowConsumer consumer, Row parameters, SubQueryResults subQueryResults) {
        CreateSnapshotRequest request = CreateSnapshotPlan.createRequest(this.createSnapshot, plannerContext.transactionContext(), dependencies.nodeContext(), parameters, subQueryResults, dependencies.schemas(), plannerContext.clusterState().metadata());
        dependencies.client().execute(CreateSnapshotAction.INSTANCE, request).whenComplete(new OneRowActionListener<CreateSnapshotResponse>(consumer, response -> {
            SnapshotInfo snapshotInfo = response.getSnapshotInfo();
            if (snapshotInfo != null && snapshotInfo.state() == SnapshotState.FAILED) {
                String reason = response.getSnapshotInfo().reason().replaceAll("Index", "Table").replaceAll("Indices", "Tables");
                CreateSnapshotException createSnapshotException = new CreateSnapshotException(this.createSnapshot.repositoryName(), this.createSnapshot.snapshotName(), reason);
                consumer.accept(null, (Throwable)createSnapshotException);
                return new Row1((Object)-1L);
            }
            return new Row1((Object)1L);
        }));
    }

    @VisibleForTesting
    public static CreateSnapshotRequest createRequest(AnalyzedCreateSnapshot createSnapshot, CoordinatorTxnCtx txnCtx, NodeContext nodeCtx, Row parameters, SubQueryResults subQueryResults, Schemas schemas, Metadata metadata) {
        HashSet<Object> snapshotIndices;
        Function<Symbol, Object> eval = x -> SymbolEvaluator.evaluate(txnCtx, nodeCtx, x, parameters, subQueryResults);
        GenericProperties properties = createSnapshot.properties().ensureContainsOnly(SnapshotSettings.SETTINGS.keySet()).map(eval);
        Settings settings = Settings.builder().put((GenericProperties<Object>)properties).build();
        boolean ignoreUnavailable = SnapshotSettings.IGNORE_UNAVAILABLE.get(settings);
        HashSet<String> templates = new HashSet<String>();
        if (createSnapshot.tables().isEmpty()) {
            for (SchemaInfo schemaInfo : schemas) {
                for (TableInfo tableInfo : schemaInfo.getTables()) {
                    if (!(tableInfo instanceof DocTableInfo)) continue;
                    Operation.blockedRaiseException(tableInfo, Operation.READ);
                }
            }
            snapshotIndices = new HashSet<String>(AnalyzedCreateSnapshot.ALL_INDICES);
        } else {
            snapshotIndices = HashSet.newHashSet(createSnapshot.tables().size());
            for (Table<Symbol> table : createSnapshot.tables()) {
                DocTableInfo docTableInfo;
                try {
                    docTableInfo = (DocTableInfo)schemas.findRelation(table.getName(), Operation.CREATE_SNAPSHOT, txnCtx.sessionSettings().sessionUser(), txnCtx.sessionSettings().searchPath());
                }
                catch (Exception e) {
                    if (ignoreUnavailable && e instanceof ResourceUnknownException) {
                        LOGGER.info("Ignore unknown relation '{}' for the '{}' snapshot'", (Object)table.getName(), (Object)createSnapshot.snapshotName());
                        continue;
                    }
                    throw e;
                }
                if (docTableInfo.isPartitioned()) {
                    templates.add(PartitionName.templateName(docTableInfo.ident().schema(), docTableInfo.ident().name()));
                }
                if (table.partitionProperties().isEmpty()) {
                    snapshotIndices.addAll(Arrays.asList(docTableInfo.concreteIndices(metadata)));
                    continue;
                }
                try {
                    PartitionName partitionName = PartitionName.ofAssignments(docTableInfo, Lists.map((Collection)table.partitionProperties(), x -> x.map(eval)), metadata);
                    snapshotIndices.add(partitionName.asIndexName());
                }
                catch (PartitionUnknownException ex) {
                    if (ignoreUnavailable) {
                        LOGGER.info("ignoring unknown partition of table '{}' with ident '{}'", (Object)ex.partitionName().relationName(), (Object)ex.partitionName().ident());
                        continue;
                    }
                    throw ex;
                }
            }
        }
        return new CreateSnapshotRequest(createSnapshot.repositoryName(), createSnapshot.snapshotName()).includeGlobalState(createSnapshot.tables().isEmpty()).waitForCompletion(SnapshotSettings.WAIT_FOR_COMPLETION.get(settings)).indices(snapshotIndices.toArray(new String[0])).indicesOptions(IndicesOptions.fromOptions(ignoreUnavailable, true, true, false, IndicesOptions.LENIENT_EXPAND_OPEN)).templates(templates.stream().toList()).settings(settings);
    }
}

