/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.node.management;

import io.crate.planner.node.management.ExplainPlan;
import io.crate.planner.node.management.OptimizerStep;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.operators.PrintContext;
import io.crate.planner.optimizer.Rule;
import io.crate.planner.optimizer.costs.PlanStats;
import io.crate.planner.optimizer.tracer.LoggingOptimizerTracer;
import io.crate.planner.optimizer.tracer.OptimizerTracer;
import java.util.ArrayList;
import java.util.List;

public class VerboseOptimizerTracer
implements OptimizerTracer {
    private final OptimizerTracer defaultTracker = LoggingOptimizerTracer.getInstance();
    private final List<OptimizerStep> steps = new ArrayList<OptimizerStep>();
    private final boolean showCosts;

    public VerboseOptimizerTracer(boolean showCosts) {
        this.showCosts = showCosts;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public void optimizationStarted(LogicalPlan initialPlan, PlanStats planStats) {
        if (this.steps.isEmpty()) {
            PrintContext printContext = ExplainPlan.createPrintContext(planStats, this.showCosts);
            initialPlan.print(printContext);
            this.steps.add(OptimizerStep.initial(printContext.toString()));
        }
        this.defaultTracker.optimizationStarted(initialPlan, planStats);
    }

    @Override
    public void ruleMatched(Rule<?> rule) {
        this.defaultTracker.ruleMatched(rule);
    }

    @Override
    public void ruleApplied(Rule<?> rule, LogicalPlan plan, PlanStats planStats) {
        PrintContext printContext = ExplainPlan.createPrintContext(planStats, this.showCosts);
        plan.print(printContext);
        this.steps.add(OptimizerStep.ruleApplied(rule, printContext.toString()));
        this.defaultTracker.ruleApplied(rule, plan, planStats);
    }

    public List<OptimizerStep> getSteps() {
        return this.steps;
    }
}

