/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.operators;

import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.ScopedSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolVisitor;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class EquiJoinDetector {
    private static final Visitor VISITOR = new Visitor();

    private EquiJoinDetector() {
    }

    public static boolean isEquiJoin(Symbol joinCondition) {
        if (joinCondition == null) {
            return false;
        }
        Context context = new Context();
        joinCondition.accept(VISITOR, context);
        return context.isHashJoinPossible;
    }

    private static class Context {
        boolean exit = false;
        boolean isHashJoinPossible = false;
        boolean insideEqualOperand = false;
        Set<RelationName> relations = new HashSet<RelationName>();

        private Context() {
        }
    }

    private static class Visitor
    extends SymbolVisitor<Context, Void> {
        private Visitor() {
        }

        @Override
        public Void visitFunction(Function function, Context context) {
            String functionName;
            if (context.exit) {
                return null;
            }
            switch (functionName = function.name()) {
                case "op_and": 
                case "cast": 
                case "_cast": {
                    for (Symbol arg : function.arguments()) {
                        arg.accept(this, context);
                    }
                    return null;
                }
                case "op_not": {
                    if (context.insideEqualOperand) {
                        for (Symbol arg : function.arguments()) {
                            arg.accept(this, context);
                        }
                        break;
                    }
                    return null;
                }
                case "op_or": {
                    if (context.insideEqualOperand) {
                        for (Symbol arg : function.arguments()) {
                            arg.accept(this, context);
                        }
                        break;
                    }
                    context.isHashJoinPossible = false;
                    context.exit = true;
                    return null;
                }
                case "op_=": {
                    List<Symbol> arguments = function.arguments();
                    Symbol left = arguments.get(0);
                    Symbol right = arguments.get(1);
                    if (context.insideEqualOperand) {
                        left.accept(this, context);
                        right.accept(this, context);
                        break;
                    }
                    Context leftContext = new Context();
                    leftContext.insideEqualOperand = true;
                    left.accept(this, leftContext);
                    Context rightContext = new Context();
                    rightContext.insideEqualOperand = true;
                    right.accept(this, rightContext);
                    if (leftContext.relations.size() != 1 || rightContext.relations.size() != 1 || leftContext.relations.equals(rightContext.relations)) break;
                    context.isHashJoinPossible = true;
                    break;
                }
                default: {
                    if (context.insideEqualOperand) {
                        for (Symbol arg : function.arguments()) {
                            arg.accept(this, context);
                        }
                        break;
                    }
                    return null;
                }
            }
            return null;
        }

        @Override
        public Void visitField(ScopedSymbol field, Context context) {
            context.relations.add(field.relation());
            return null;
        }

        @Override
        public Void visitReference(Reference ref, Context context) {
            context.relations.add(ref.ident().tableIdent());
            return null;
        }
    }
}

