/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.operators;

import io.crate.analyze.OrderBy;
import io.crate.common.collections.Lists;
import io.crate.data.Row;
import io.crate.execution.dsl.projection.EvalProjection;
import io.crate.execution.dsl.projection.builder.InputColumns;
import io.crate.execution.dsl.projection.builder.ProjectionBuilder;
import io.crate.expression.symbol.FetchMarker;
import io.crate.expression.symbol.Symbol;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.ExecutionPlan;
import io.crate.planner.Merge;
import io.crate.planner.PlannerContext;
import io.crate.planner.PositionalOrderBy;
import io.crate.planner.operators.FetchRewrite;
import io.crate.planner.operators.ForwardingLogicalPlan;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.operators.LogicalPlanVisitor;
import io.crate.planner.operators.PlanHint;
import io.crate.planner.operators.SubQueryAndParamBinder;
import io.crate.planner.operators.SubQueryResults;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.SequencedCollection;
import java.util.Set;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.Nullable;

public final class Eval
extends ForwardingLogicalPlan {
    private final List<Symbol> outputs;

    public static LogicalPlan create(LogicalPlan source, List<Symbol> outputs) {
        if (source.outputs().equals(outputs)) {
            return source;
        }
        return new Eval(source, outputs);
    }

    Eval(LogicalPlan source, List<Symbol> outputs) {
        super(source);
        this.outputs = outputs;
    }

    @Override
    public ExecutionPlan build(DependencyCarrier executor, PlannerContext plannerContext, Set<PlanHint> planHints, ProjectionBuilder projectionBuilder, int limit, int offset, @Nullable OrderBy order, @Nullable Integer pageSizeHint, Row params, SubQueryResults subQueryResults) {
        ExecutionPlan executionPlan = this.source.build(executor, plannerContext, planHints, projectionBuilder, limit, offset, null, pageSizeHint, params, subQueryResults);
        if (this.outputs.equals(this.source.outputs())) {
            return executionPlan;
        }
        return this.addEvalProjection(plannerContext, executionPlan, params, subQueryResults);
    }

    @Override
    public List<Symbol> outputs() {
        return this.outputs;
    }

    @Override
    public LogicalPlan replaceSources(List<LogicalPlan> sources) {
        return new Eval((LogicalPlan)Lists.getOnlyElement(sources), this.outputs);
    }

    @Override
    public LogicalPlan pruneOutputsExcept(SequencedCollection<Symbol> outputsToKeep) {
        LogicalPlan newSource = this.source.pruneOutputsExcept(outputsToKeep);
        if (this.source == newSource && this.outputs.isEmpty()) {
            return this;
        }
        return new Eval(newSource, List.copyOf(outputsToKeep));
    }

    @Override
    @Nullable
    public FetchRewrite rewriteToFetch(Collection<Symbol> usedColumns) {
        FetchRewrite fetchRewrite = this.source.rewriteToFetch(usedColumns);
        if (fetchRewrite == null) {
            return null;
        }
        LogicalPlan newSource = fetchRewrite.newPlan();
        UnaryOperator<Symbol> mapToFetchStubs = fetchRewrite.mapToFetchStubs();
        LinkedHashMap<Symbol, Symbol> newReplacedOutputs = new LinkedHashMap<Symbol, Symbol>();
        ArrayList<Symbol> newOutputs = new ArrayList<Symbol>();
        for (Symbol sourceOutput : newSource.outputs()) {
            if (!(sourceOutput instanceof FetchMarker)) continue;
            newOutputs.add(sourceOutput);
        }
        for (Symbol output : this.outputs) {
            newReplacedOutputs.put(output, (Symbol)mapToFetchStubs.apply(output));
            if (!output.any(newSource.outputs()::contains)) continue;
            newOutputs.add(output);
        }
        return new FetchRewrite(newReplacedOutputs, Eval.create(newSource, newOutputs));
    }

    private ExecutionPlan addEvalProjection(PlannerContext plannerContext, ExecutionPlan executionPlan, Row params, SubQueryResults subQueryResults) {
        PositionalOrderBy orderBy = executionPlan.resultDescription().orderBy();
        PositionalOrderBy newOrderBy = null;
        SubQueryAndParamBinder binder = new SubQueryAndParamBinder(params, subQueryResults);
        List boundOutputs = Lists.map(this.outputs, (Function)binder);
        if (orderBy != null && (newOrderBy = orderBy.tryMapToNewOutputs(this.source.outputs(), boundOutputs)) == null) {
            executionPlan = Merge.ensureOnHandler(executionPlan, plannerContext);
        }
        InputColumns.SourceSymbols ctx = new InputColumns.SourceSymbols(Lists.map(this.source.outputs(), (Function)binder));
        EvalProjection projection = new EvalProjection(InputColumns.create(boundOutputs, ctx));
        executionPlan.addProjection(projection, executionPlan.resultDescription().limit(), executionPlan.resultDescription().offset(), newOrderBy);
        return executionPlan;
    }

    public String toString() {
        return "Eval{src=" + String.valueOf(this.source) + ", out=" + String.valueOf(this.outputs) + "}";
    }

    @Override
    public <C, R> R accept(LogicalPlanVisitor<C, R> visitor, C context) {
        return visitor.visitEval(this, context);
    }
}

