/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.operators;

import io.crate.expression.symbol.FetchMarker;
import io.crate.expression.symbol.InputColumn;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import io.crate.planner.node.fetch.FetchSource;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.operators.MapBackedSymbolReplacer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;

public final class FetchRewrite {
    private final Map<Symbol, Symbol> replacedOutputs;
    private final LogicalPlan plan;

    public FetchRewrite(Map<Symbol, Symbol> replacedOutputs, LogicalPlan plan) {
        this.replacedOutputs = replacedOutputs;
        this.plan = plan;
    }

    public LogicalPlan newPlan() {
        return this.plan;
    }

    public List<Reference> extractFetchRefs() {
        ArrayList<Reference> allFetchReferences = new ArrayList<Reference>();
        for (Symbol output : this.plan.outputs()) {
            if (!(output instanceof FetchMarker)) continue;
            FetchMarker fetchMarker = (FetchMarker)output;
            allFetchReferences.addAll(fetchMarker.fetchRefs());
        }
        return allFetchReferences;
    }

    public Map<RelationName, FetchSource> createFetchSources() {
        HashMap<RelationName, FetchSource> fetchSources = new HashMap<RelationName, FetchSource>();
        List<Symbol> outputs = this.plan.outputs();
        for (int i = 0; i < outputs.size(); ++i) {
            Symbol output = outputs.get(i);
            if (!(output instanceof FetchMarker)) continue;
            FetchMarker fetchMarker = (FetchMarker)output;
            RelationName tableName = fetchMarker.fetchId().ident().tableIdent();
            FetchSource fetchSource = fetchSources.get(tableName);
            if (fetchSource == null) {
                fetchSource = new FetchSource();
                fetchSources.put(tableName, fetchSource);
            }
            fetchSource.addFetchIdColumn(new InputColumn(i, fetchMarker.valueType()));
            for (Reference fetchRef : fetchMarker.fetchRefs()) {
                fetchSource.addRefToFetch(fetchRef);
            }
        }
        return fetchSources;
    }

    public Map<Symbol, Symbol> replacedOutputs() {
        return this.replacedOutputs;
    }

    public UnaryOperator<Symbol> mapToFetchStubs() {
        return s -> MapBackedSymbolReplacer.convert(s, this.replacedOutputs);
    }
}

