/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.operators;

import io.crate.analyze.OrderBy;
import io.crate.common.collections.Lists;
import io.crate.data.Row;
import io.crate.execution.dsl.projection.OrderedLimitAndOffsetProjection;
import io.crate.execution.dsl.projection.builder.InputColumns;
import io.crate.execution.dsl.projection.builder.ProjectionBuilder;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.Symbols;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.ExecutionPlan;
import io.crate.planner.Merge;
import io.crate.planner.PlannerContext;
import io.crate.planner.PositionalOrderBy;
import io.crate.planner.operators.Collect;
import io.crate.planner.operators.FetchRewrite;
import io.crate.planner.operators.ForwardingLogicalPlan;
import io.crate.planner.operators.Limit;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.operators.LogicalPlanVisitor;
import io.crate.planner.operators.PlanHint;
import io.crate.planner.operators.PrintContext;
import io.crate.planner.operators.SubQueryAndParamBinder;
import io.crate.planner.operators.SubQueryResults;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.Nullable;

public class Order
extends ForwardingLogicalPlan {
    final OrderBy orderBy;
    private final List<Symbol> outputs;

    static LogicalPlan create(LogicalPlan source, @Nullable OrderBy orderBy) {
        if (orderBy == null) {
            return source;
        }
        return new Order(source, orderBy);
    }

    public Order(LogicalPlan source, OrderBy orderBy) {
        super(source);
        this.outputs = Lists.concatUnique(source.outputs(), orderBy.orderBySymbols());
        this.orderBy = orderBy;
    }

    public OrderBy orderBy() {
        return this.orderBy;
    }

    @Override
    public LogicalPlan pruneOutputsExcept(SequencedCollection<Symbol> outputsToKeep) {
        LinkedHashSet<Symbol> toKeep = new LinkedHashSet<Symbol>();
        for (Symbol outputToKeep : outputsToKeep) {
            Symbols.intersection(outputToKeep, this.source.outputs(), toKeep::add);
        }
        for (Symbol orderBySymbol : this.orderBy.orderBySymbols()) {
            Symbols.intersection(orderBySymbol, this.source.outputs(), toKeep::add);
        }
        LogicalPlan newSource = this.source.pruneOutputsExcept(toKeep);
        if (newSource == this.source) {
            return this;
        }
        return this.replaceSources(List.of(newSource));
    }

    @Override
    @Nullable
    public FetchRewrite rewriteToFetch(Collection<Symbol> usedColumns) {
        HashSet<Symbol> allUsedColumns = new HashSet<Symbol>(usedColumns);
        allUsedColumns.addAll(this.orderBy.orderBySymbols());
        FetchRewrite fetchRewrite = this.source.rewriteToFetch(allUsedColumns);
        if (fetchRewrite == null) {
            return null;
        }
        LogicalPlan newSource = fetchRewrite.newPlan();
        Order newOrderBy = new Order(newSource, this.orderBy);
        Map<Symbol, Symbol> replacedOutputs = fetchRewrite.replacedOutputs();
        if (newOrderBy.outputs.size() > newSource.outputs().size()) {
            LinkedHashMap<Symbol, Symbol> newReplacedOutputs = new LinkedHashMap<Symbol, Symbol>(replacedOutputs);
            UnaryOperator<Symbol> mapToFetchStubs = fetchRewrite.mapToFetchStubs();
            for (int i = newSource.outputs().size(); i < newOrderBy.outputs.size(); ++i) {
                Symbol extraOutput = newOrderBy.outputs.get(i);
                newReplacedOutputs.put(extraOutput, (Symbol)mapToFetchStubs.apply(extraOutput));
            }
            return new FetchRewrite(newReplacedOutputs, newOrderBy);
        }
        return new FetchRewrite(replacedOutputs, newOrderBy);
    }

    @Override
    public ExecutionPlan build(DependencyCarrier executor, PlannerContext plannerContext, Set<PlanHint> planHints, ProjectionBuilder projectionBuilder, int limit, int offset, @Nullable OrderBy order, @Nullable Integer pageSizeHint, Row params, SubQueryResults subQueryResults) {
        ExecutionPlan plan = this.source.build(executor, plannerContext, planHints, projectionBuilder, limit, offset, this.orderBy, pageSizeHint, params, subQueryResults);
        if (plan.resultDescription().orderBy() != null && this.source instanceof Collect) {
            return plan;
        }
        if (plan.resultDescription().hasRemainingLimitOrOffset()) {
            plan = Merge.ensureOnHandler(plan, plannerContext);
        }
        SubQueryAndParamBinder binder = new SubQueryAndParamBinder(params, subQueryResults);
        List boundOutputs = Lists.map(this.outputs, (Function)binder);
        InputColumns.SourceSymbols ctx = new InputColumns.SourceSymbols(Lists.map(this.source.outputs(), (Function)binder));
        List boundOrderBySymbols = Lists.map(this.orderBy.orderBySymbols(), (Function)binder);
        List<Symbol> orderByInputColumns = InputColumns.create(boundOrderBySymbols, ctx);
        OrderBy boundOrderBy = new OrderBy(boundOrderBySymbols, this.orderBy.reverseFlags(), this.orderBy.nullsFirst());
        Order.ensureOrderByColumnsArePresentInOutputs(orderByInputColumns);
        OrderedLimitAndOffsetProjection orderedLimitAndOffsetProjection = new OrderedLimitAndOffsetProjection(Limit.limitAndOffset(limit, offset), 0, InputColumns.create(boundOutputs, ctx), orderByInputColumns, boundOrderBy.reverseFlags(), boundOrderBy.nullsFirst());
        PositionalOrderBy positionalOrderBy = PositionalOrderBy.of(boundOrderBy, boundOutputs);
        plan.addProjection(orderedLimitAndOffsetProjection, limit, offset, positionalOrderBy);
        return plan;
    }

    private static void ensureOrderByColumnsArePresentInOutputs(List<Symbol> orderByInputColumns) {
        Consumer<Symbol> raiseExpressionMissingInOutputsError = symbol -> {
            throw new UnsupportedOperationException(Symbols.format("Cannot ORDER BY `%s`, the column does not appear in the outputs of the underlying relation", symbol));
        };
        for (Symbol orderByInputColumn : orderByInputColumns) {
            orderByInputColumn.visit(Symbol.IS_COLUMN, raiseExpressionMissingInOutputsError);
        }
    }

    @Override
    public List<Symbol> outputs() {
        return this.outputs;
    }

    @Override
    public LogicalPlan replaceSources(List<LogicalPlan> sources) {
        return new Order((LogicalPlan)Lists.getOnlyElement(sources), this.orderBy);
    }

    public String toString() {
        return "Order{src=" + String.valueOf(this.source) + ", " + String.valueOf(this.orderBy) + "}";
    }

    @Override
    public <C, R> R accept(LogicalPlanVisitor<C, R> visitor, C context) {
        return visitor.visitOrder(this, context);
    }

    @Override
    public void print(PrintContext printContext) {
        StringBuilder orderByExprRepr = new StringBuilder();
        OrderBy.explainRepresentation(orderByExprRepr, this.orderBy.orderBySymbols(), this.orderBy.reverseFlags(), this.orderBy.nullsFirst(), (Function<Symbol, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lio/crate/expression/symbol/Symbol;)Ljava/lang/String;)());
        printContext.text("OrderBy[").text(orderByExprRepr.toString()).text("]");
        this.printStats(printContext);
        Consumer[] consumerArray = new Consumer[1];
        consumerArray[0] = this.source::print;
        printContext.nest(consumerArray);
    }
}

