/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.operators;

import io.crate.analyze.OrderBy;
import io.crate.analyze.WindowDefinition;
import io.crate.common.collections.Lists;
import io.crate.data.Row;
import io.crate.execution.dsl.phases.ExecutionPhases;
import io.crate.execution.dsl.phases.MergePhase;
import io.crate.execution.dsl.projection.Projection;
import io.crate.execution.dsl.projection.WindowAggProjection;
import io.crate.execution.dsl.projection.builder.InputColumns;
import io.crate.execution.dsl.projection.builder.ProjectionBuilder;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.Symbols;
import io.crate.expression.symbol.WindowFunction;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.ExecutionPlan;
import io.crate.planner.Merge;
import io.crate.planner.PlannerContext;
import io.crate.planner.ResultDescription;
import io.crate.planner.distribution.DistributionInfo;
import io.crate.planner.distribution.DistributionType;
import io.crate.planner.operators.Eval;
import io.crate.planner.operators.ForwardingLogicalPlan;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.operators.LogicalPlanVisitor;
import io.crate.planner.operators.PlanHint;
import io.crate.planner.operators.PrintContext;
import io.crate.planner.operators.SubQueryAndParamBinder;
import io.crate.planner.operators.SubQueryResults;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.Set;
import java.util.function.Function;
import org.elasticsearch.common.UUIDs;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class WindowAgg
extends ForwardingLogicalPlan {
    final WindowDefinition windowDefinition;
    private final List<WindowFunction> windowFunctions;
    private final List<Symbol> standalone;
    private final List<Symbol> outputs;

    @VisibleForTesting
    public static LogicalPlan create(LogicalPlan source, List<WindowFunction> windowFunctions) {
        ArrayList functions;
        if (windowFunctions.isEmpty()) {
            return source;
        }
        LinkedHashMap<WindowDefinition, ArrayList> groupedFunctions = new LinkedHashMap<WindowDefinition, ArrayList>();
        for (WindowFunction windowFunction : windowFunctions) {
            WindowDefinition windowDefinition = windowFunction.windowDefinition();
            functions = groupedFunctions.computeIfAbsent(windowDefinition, w -> new ArrayList());
            functions.add(windowFunction);
        }
        LogicalPlan lastWindowAgg = source;
        for (Map.Entry entry : groupedFunctions.entrySet()) {
            functions = (ArrayList)entry.getValue();
            WindowDefinition windowDefinition = (WindowDefinition)entry.getKey();
            OrderBy orderBy = windowDefinition.orderBy();
            if (orderBy == null || lastWindowAgg.outputs().containsAll(orderBy.orderBySymbols())) {
                lastWindowAgg = new WindowAgg(lastWindowAgg, windowDefinition, functions, lastWindowAgg.outputs());
                continue;
            }
            Eval eval = new Eval(lastWindowAgg, Lists.concatUnique(lastWindowAgg.outputs(), orderBy.orderBySymbols()));
            lastWindowAgg = new WindowAgg(eval, windowDefinition, functions, eval.outputs());
        }
        return lastWindowAgg;
    }

    private WindowAgg(LogicalPlan source, WindowDefinition windowDefinition, List<WindowFunction> windowFunctions, List<Symbol> standalone) {
        super(source);
        this.outputs = Lists.concat(standalone, windowFunctions);
        this.windowDefinition = windowDefinition;
        this.windowFunctions = windowFunctions;
        this.standalone = standalone;
    }

    @Override
    public LogicalPlan pruneOutputsExcept(SequencedCollection<Symbol> outputsToKeep) {
        LinkedHashSet<Symbol> toKeep = new LinkedHashSet<Symbol>();
        ArrayList newWindowFunctions = new ArrayList();
        for (Symbol outputToKeep : outputsToKeep) {
            Symbols.intersection(outputToKeep, this.windowFunctions, newWindowFunctions::add);
            Symbols.intersection(outputToKeep, this.standalone, toKeep::add);
        }
        for (WindowFunction newWindowFunction : newWindowFunctions) {
            Symbols.intersection(newWindowFunction, this.source.outputs(), toKeep::add);
        }
        LogicalPlan newSource = this.source.pruneOutputsExcept(toKeep);
        if (newSource == this.source) {
            return this;
        }
        if (newWindowFunctions.isEmpty()) {
            return newSource;
        }
        return new WindowAgg(newSource, this.windowDefinition, List.copyOf(newWindowFunctions), newSource.outputs());
    }

    public List<WindowFunction> windowFunctions() {
        return this.windowFunctions;
    }

    @Override
    public ExecutionPlan build(DependencyCarrier executor, PlannerContext plannerContext, Set<PlanHint> planHints, ProjectionBuilder projectionBuilder, int limit, int offset, @Nullable OrderBy order, @Nullable Integer pageSizeHint, Row params, SubQueryResults subQueryResults) {
        boolean nonDistExecution;
        InputColumns.SourceSymbols sourceSymbols = new InputColumns.SourceSymbols(this.source.outputs());
        SubQueryAndParamBinder binder = new SubQueryAndParamBinder(params, subQueryResults);
        Function toInputCols = binder.andThen(s -> InputColumns.create(s, sourceSymbols));
        List boundWindowFunctions = Lists.map(this.windowFunctions, toInputCols);
        ArrayList<Projection> projections = new ArrayList<Projection>();
        WindowAggProjection windowAggProjection = new WindowAggProjection(this.windowDefinition.map(toInputCols), boundWindowFunctions, InputColumns.create(this.standalone, sourceSymbols));
        projections.add(windowAggProjection);
        ExecutionPlan sourcePlan = this.source.build(executor, plannerContext, planHints, projectionBuilder, -1, 0, null, pageSizeHint, params, subQueryResults);
        ResultDescription resultDescription = sourcePlan.resultDescription();
        boolean executesOnHandler = ExecutionPhases.executesOnHandler(plannerContext.handlerNode(), resultDescription.nodeIds());
        boolean bl = nonDistExecution = this.windowDefinition.partitions().isEmpty() || resultDescription.hasRemainingLimitOrOffset() || executesOnHandler;
        if (nonDistExecution) {
            sourcePlan = Merge.ensureOnHandler(sourcePlan, plannerContext);
            for (Projection projection : projections) {
                sourcePlan.addProjection(projection);
            }
        } else {
            Symbol firstPartition = this.windowDefinition.partitions().getFirst();
            int index = this.source.outputs().indexOf(firstPartition);
            if (index == -1) {
                ArrayList intersection = new ArrayList();
                Symbols.intersection(firstPartition, this.source.outputs(), intersection::add);
                assert (!intersection.isEmpty()) : "Intersection of source outputs and partition definition must not be empty";
                index = this.source.outputs().indexOf(intersection.getFirst());
            }
            assert (index >= 0 && index < this.source.outputs().size()) : "Column to distribute must be present in the source plan outputs";
            sourcePlan.setDistributionInfo(new DistributionInfo(DistributionType.MODULO, index));
            MergePhase distWindowAgg = new MergePhase(UUIDs.dirtyUUID(), plannerContext.nextExecutionPhaseId(), "distWindowAgg", resultDescription.nodeIds().size(), resultDescription.numOutputs(), resultDescription.nodeIds(), resultDescription.streamOutputs(), projections, resultDescription.nodeIds(), DistributionInfo.DEFAULT_BROADCAST, null);
            return new Merge(sourcePlan, distWindowAgg, -1, 0, windowAggProjection.outputs().size(), resultDescription.maxRowsPerNode(), null);
        }
        return sourcePlan;
    }

    @Nullable
    static OrderBy createOrderByInclPartitionBy(WindowDefinition windowDefinition) {
        OrderBy orderBy = windowDefinition.orderBy();
        List<Symbol> partitions = windowDefinition.partitions();
        if (orderBy == null) {
            if (partitions.isEmpty()) {
                return null;
            }
            return new OrderBy(partitions);
        }
        return orderBy.prependUnique(partitions);
    }

    @Override
    public <C, R> R accept(LogicalPlanVisitor<C, R> visitor, C context) {
        return visitor.visitWindowAgg(this, context);
    }

    @Override
    public List<Symbol> outputs() {
        return this.outputs;
    }

    public WindowDefinition windowDefinition() {
        return this.windowDefinition;
    }

    @Override
    public LogicalPlan replaceSources(List<LogicalPlan> sources) {
        return new WindowAgg((LogicalPlan)Lists.getOnlyElement(sources), this.windowDefinition, this.windowFunctions, this.standalone);
    }

    public String toString() {
        return "WindowAgg{source=" + String.valueOf(this.source) + ", windowDefinition=" + String.valueOf(this.windowDefinition) + ", windowFunctions=[" + Lists.joinOn((String)", ", this.windowFunctions, WindowFunction::toString) + "]}";
    }

    @Override
    public void print(PrintContext printContext) {
        printContext.text(this.getClass().getSimpleName()).text("[").text(Lists.joinOn((String)", ", this.standalone, (Function<Symbol, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lio/crate/expression/symbol/Symbol;)Ljava/lang/String;)())).text("]").text(" | [").text(Lists.joinOn((String)", ", this.windowFunctions, (Function<WindowFunction, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lio/crate/expression/symbol/WindowFunction;)Ljava/lang/String;)())).text("]");
        this.printStats(printContext);
        printContext.nest(Lists.map(this.sources(), x -> x::print));
    }
}

