/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.optimizer.rule;

import io.crate.analyze.OrderBy;
import io.crate.analyze.RelationNames;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.RelationName;
import io.crate.planner.operators.AbstractJoinPlan;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.operators.NestedLoopJoin;
import io.crate.planner.operators.Order;
import io.crate.planner.optimizer.Rule;
import io.crate.planner.optimizer.matcher.Capture;
import io.crate.planner.optimizer.matcher.Captures;
import io.crate.planner.optimizer.matcher.Pattern;
import io.crate.planner.optimizer.matcher.Patterns;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;

public final class MoveOrderBeneathNestedLoop
implements Rule<Order> {
    private final Capture<NestedLoopJoin> nlCapture = new Capture();
    private final Pattern<Order> pattern = Pattern.typeOf(Order.class).with(Patterns.source(), Pattern.typeOf(NestedLoopJoin.class).capturedAs(this.nlCapture).with(nl -> !nl.joinType().isOuter()));

    @Override
    public Pattern<Order> pattern() {
        return this.pattern;
    }

    @Override
    public LogicalPlan apply(Order order, Captures captures, Rule.Context ruleContext) {
        RelationName topMostLeftRelation;
        RelationName relationInOrderBy;
        NestedLoopJoin nestedLoop = captures.get(this.nlCapture);
        Set relationsInOrderBy = Collections.newSetFromMap(new IdentityHashMap());
        OrderBy orderBy = order.orderBy();
        for (Symbol orderExpr : orderBy.orderBySymbols()) {
            relationsInOrderBy.addAll(RelationNames.getShallow(orderExpr));
        }
        if (relationsInOrderBy.size() == 1 && (relationInOrderBy = (RelationName)relationsInOrderBy.iterator().next()).equals(topMostLeftRelation = nestedLoop.relationNames().get(0))) {
            LogicalPlan lhs = nestedLoop.sources().get(0);
            LogicalPlan newLhs = order.replaceSources(List.of(lhs));
            return new NestedLoopJoin(newLhs, nestedLoop.sources().get(1), nestedLoop.joinType(), nestedLoop.joinCondition(), nestedLoop.isFiltered(), true, nestedLoop.isRewriteNestedLoopJoinToHashJoinDone(), AbstractJoinPlan.LookUpJoin.NONE);
        }
        return null;
    }
}

