/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.optimizer.rule;

import io.crate.analyze.relations.QuerySplitter;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.RelationName;
import io.crate.planner.operators.EquiJoinDetector;
import io.crate.planner.operators.Filter;
import io.crate.planner.operators.JoinPlan;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.optimizer.Rule;
import io.crate.planner.optimizer.matcher.Capture;
import io.crate.planner.optimizer.matcher.Captures;
import io.crate.planner.optimizer.matcher.Pattern;
import io.crate.planner.optimizer.matcher.Patterns;
import io.crate.sql.tree.JoinType;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class RewriteFilterOnCrossJoinToInnerJoin
implements Rule<Filter> {
    private final Capture<JoinPlan> joinCapture = new Capture();
    private final Pattern<Filter> pattern = Pattern.typeOf(Filter.class).with(f -> EquiJoinDetector.isEquiJoin(f.query())).with(Patterns.source(), Pattern.typeOf(JoinPlan.class).capturedAs(this.joinCapture).with(j -> j.joinType() == JoinType.CROSS));

    @Override
    public Pattern<Filter> pattern() {
        return this.pattern;
    }

    @Override
    public LogicalPlan apply(Filter equiJoinConditionFilter, Captures captures, Rule.Context context) {
        JoinPlan crossJoin = captures.get(this.joinCapture);
        Symbol query = equiJoinConditionFilter.query();
        Map<Set<RelationName>, Symbol> filterRelations = QuerySplitter.split(query);
        List<RelationName> lhs = crossJoin.lhs().relationNames();
        List<RelationName> rhs = crossJoin.rhs().relationNames();
        if (lhs.size() == 1 && rhs.size() == 1) {
            HashSet sources = HashSet.newHashSet(2);
            sources.addAll(lhs);
            sources.addAll(rhs);
            if (filterRelations.containsKey(sources)) {
                return new JoinPlan(crossJoin.lhs(), crossJoin.rhs(), JoinType.INNER, query);
            }
        }
        return null;
    }
}

