/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.optimizer.rule;

import io.crate.planner.operators.EquiJoinDetector;
import io.crate.planner.operators.Eval;
import io.crate.planner.operators.HashJoin;
import io.crate.planner.operators.JoinPlan;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.optimizer.Rule;
import io.crate.planner.optimizer.matcher.Captures;
import io.crate.planner.optimizer.matcher.Pattern;
import io.crate.sql.tree.JoinType;

public class RewriteRightOuterJoinToHashJoin
implements Rule<JoinPlan> {
    private final Pattern<JoinPlan> pattern = Pattern.typeOf(JoinPlan.class).with(j -> j.joinType() == JoinType.RIGHT && EquiJoinDetector.isEquiJoin(j.joinCondition()));

    @Override
    public Pattern<JoinPlan> pattern() {
        return this.pattern;
    }

    @Override
    public LogicalPlan apply(JoinPlan join, Captures captures, Rule.Context context) {
        if (context.txnCtx().sessionSettings().hashJoinsEnabled()) {
            return Eval.create(new HashJoin(join.rhs(), join.lhs(), join.joinCondition(), JoinType.LEFT, join.lookUpJoin()), join.outputs());
        }
        return null;
    }
}

