/*
 * Decompiled with CFR 0.152.
 */
package io.crate.protocols.postgres;

import io.crate.protocols.postgres.KeyData;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.lucene.BytesRefs;

class ClientMessages {
    ClientMessages() {
    }

    static ByteBuf writeSSLReqMessage(ByteBuf buffer) {
        buffer.writeInt(8);
        buffer.writeInt(80877103);
        return buffer;
    }

    static ByteBuf writePasswordMessage(ByteBuf buffer, String password) {
        byte[] passwordBytes = password.getBytes(StandardCharsets.UTF_8);
        buffer.writeByte(112);
        buffer.writeInt(4 + passwordBytes.length + 1);
        buffer.writeBytes(passwordBytes);
        buffer.writeByte(0);
        return buffer;
    }

    static ByteBuf sendStartupMessage(ByteBuf buffer, String dbName, Map<String, String> properties) {
        int length = 8;
        int protocolVersion = 196608;
        int lengthIndex = buffer.writerIndex();
        buffer.writeInt(length);
        buffer.writeInt(protocolVersion);
        byte[] dbKey = "database".getBytes(StandardCharsets.UTF_8);
        length += dbKey.length + 1;
        buffer.writeBytes(dbKey);
        buffer.writeByte(0);
        byte[] dbValue = dbName.getBytes(StandardCharsets.UTF_8);
        length += dbValue.length + 1;
        buffer.writeBytes(dbValue);
        buffer.writeByte(0);
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            byte[] key = entry.getKey().getBytes(StandardCharsets.UTF_8);
            byte[] value = entry.getValue().getBytes(StandardCharsets.UTF_8);
            length += key.length + value.length + 2;
            buffer.writeBytes(key);
            buffer.writeByte(0);
            buffer.writeBytes(value);
            buffer.writeByte(0);
        }
        buffer.setInt(lengthIndex, length);
        return buffer;
    }

    static void sendParseMessage(ByteBuf buffer, String stmtName, String query, int[] paramOids) {
        buffer.writeByte(80);
        byte[] stmtNameBytes = stmtName.getBytes(StandardCharsets.UTF_8);
        byte[] queryBytes = query.getBytes(StandardCharsets.UTF_8);
        buffer.writeInt(4 + stmtNameBytes.length + 1 + queryBytes.length + 1 + 2 + paramOids.length * 4);
        ClientMessages.writeCString(buffer, stmtNameBytes);
        ClientMessages.writeCString(buffer, queryBytes);
        buffer.writeShort(paramOids.length);
        for (int paramOid : paramOids) {
            buffer.writeInt(paramOid);
        }
    }

    private static void writeCString(ByteBuf buffer, byte[] bytes) {
        buffer.writeBytes(bytes);
        buffer.writeByte(0);
    }

    static void sendFlush(ByteBuf buffer) {
        buffer.writeByte(72);
        buffer.writeInt(4);
    }

    static void sendBindMessage(ByteBuf buffer, String portalName, String statementName, List<Object> params) {
        buffer.writeByte(66);
        byte[] portalBytes = portalName.getBytes(StandardCharsets.UTF_8);
        byte[] statementBytes = statementName.getBytes(StandardCharsets.UTF_8);
        int beforeLengthWriterIndex = buffer.writerIndex();
        buffer.writeInt(0);
        ClientMessages.writeCString(buffer, portalBytes);
        ClientMessages.writeCString(buffer, statementBytes);
        buffer.writeShort(0);
        buffer.writeShort(params.size());
        int paramsLength = 0;
        for (Object param : params) {
            BytesRef value = BytesRefs.toBytesRef(param);
            buffer.writeInt(value.length);
            buffer.writeBytes(value.bytes, value.offset, value.length);
            paramsLength += 4 + value.length;
        }
        buffer.writeShort(0);
        buffer.setInt(beforeLengthWriterIndex, 4 + portalBytes.length + 1 + statementBytes.length + 1 + 2 + 2 + paramsLength + 2);
    }

    static void sendDescribeMessage(ByteBuf buffer, DescribeType describeType, String portalOrStatement) {
        byte[] portalOrStatementBytes = portalOrStatement.getBytes(StandardCharsets.UTF_8);
        int length = 5 + portalOrStatementBytes.length + 1;
        buffer.writeByte(68);
        buffer.writeInt(length);
        buffer.writeByte((int)describeType.identifier);
        buffer.writeBytes(portalOrStatementBytes);
        buffer.writeByte(0);
    }

    static void sendPasswordMessage(ByteBuf buffer, String password) {
        byte[] passwordBytes = password.getBytes(StandardCharsets.UTF_8);
        int length = 4 + passwordBytes.length + 1;
        buffer.writeByte(112);
        buffer.writeInt(length);
        buffer.writeBytes(passwordBytes);
        buffer.writeByte(0);
    }

    static void sendTermination(ByteBuf buffer) {
        buffer.writeByte(88);
        buffer.writeInt(4);
    }

    static void sendCancelRequest(ByteBuf buffer, KeyData keyData) {
        buffer.writeInt(16);
        buffer.writeInt(80877102);
        buffer.writeInt(keyData.pid());
        buffer.writeInt(keyData.secretKey());
    }

    static void sendExecute(ByteBuf buffer, String portalName, int numRows) {
        byte[] portalNameBytes = portalName.getBytes(StandardCharsets.UTF_8);
        int length = 4 + portalNameBytes.length + 1 + 4;
        buffer.writeByte(69);
        buffer.writeInt(length);
        buffer.writeBytes(portalNameBytes);
        buffer.writeByte(0);
        buffer.writeInt(numRows);
    }

    static enum DescribeType {
        PORTAL('P'),
        STATEMENT('S');

        private final char identifier;

        private DescribeType(char identifier) {
            this.identifier = identifier;
        }
    }
}

