/*
 * Decompiled with CFR 0.152.
 */
package io.crate.protocols.postgres;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelId;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelProgressivePromise;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCountUtil;
import java.net.SocketAddress;
import java.util.ArrayDeque;
import java.util.ArrayList;
import org.jetbrains.annotations.Nullable;

public class DelayableWriteChannel
implements Channel {
    private final Channel delegate;
    private DelayedWrites delay = null;

    public DelayableWriteChannel(Channel channel) {
        this.delegate = channel;
        channel.closeFuture().addListener(future -> this.discardDelayedWrites());
    }

    public <T> Attribute<T> attr(AttributeKey<T> key) {
        return this.delegate.attr(key);
    }

    public <T> boolean hasAttr(AttributeKey<T> key) {
        return this.delegate.hasAttr(key);
    }

    public ChannelFuture bind(SocketAddress localAddress) {
        return this.delegate.bind(localAddress);
    }

    public ChannelFuture connect(SocketAddress remoteAddress) {
        return this.delegate.connect(remoteAddress);
    }

    public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress) {
        return this.delegate.connect(remoteAddress, localAddress);
    }

    public ChannelFuture disconnect() {
        return this.delegate.disconnect();
    }

    public ChannelFuture close() {
        return this.delegate.close();
    }

    public ChannelFuture deregister() {
        return this.delegate.deregister();
    }

    public ChannelFuture bind(SocketAddress localAddress, ChannelPromise promise) {
        return this.delegate.bind(localAddress, promise);
    }

    public ChannelFuture connect(SocketAddress remoteAddress, ChannelPromise promise) {
        return this.delegate.connect(remoteAddress, promise);
    }

    public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
        return this.delegate.connect(remoteAddress, localAddress, promise);
    }

    public ChannelFuture disconnect(ChannelPromise promise) {
        return this.delegate.disconnect(promise);
    }

    public ChannelFuture close(ChannelPromise promise) {
        return this.delegate.close(promise);
    }

    public ChannelFuture deregister(ChannelPromise promise) {
        return this.delegate.deregister(promise);
    }

    public ChannelFuture write(Object msg) {
        return this.write(msg, this.newPromise());
    }

    public ChannelFuture writeAndFlush(Object msg) {
        return this.writeAndFlush(msg, this.newPromise());
    }

    public ChannelPromise newPromise() {
        return this.delegate.newPromise();
    }

    public ChannelProgressivePromise newProgressivePromise() {
        return this.delegate.newProgressivePromise();
    }

    public ChannelFuture newSucceededFuture() {
        return this.delegate.newSucceededFuture();
    }

    public ChannelFuture newFailedFuture(Throwable cause) {
        return this.delegate.newFailedFuture(cause);
    }

    public ChannelPromise voidPromise() {
        return this.delegate.voidPromise();
    }

    public int compareTo(Channel o) {
        return this.delegate.compareTo((Object)o);
    }

    public ChannelId id() {
        return this.delegate.id();
    }

    public EventLoop eventLoop() {
        return this.delegate.eventLoop();
    }

    public Channel parent() {
        return this.delegate.parent();
    }

    public ChannelConfig config() {
        return this.delegate.config();
    }

    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    public boolean isRegistered() {
        return this.delegate.isRegistered();
    }

    public boolean isActive() {
        return this.delegate.isActive();
    }

    public ChannelMetadata metadata() {
        return this.delegate.metadata();
    }

    public SocketAddress localAddress() {
        return this.delegate.localAddress();
    }

    public SocketAddress remoteAddress() {
        return this.delegate.remoteAddress();
    }

    public ChannelFuture closeFuture() {
        return this.delegate.closeFuture();
    }

    public boolean isWritable() {
        return this.delegate.isWritable();
    }

    public long bytesBeforeUnwritable() {
        return this.delegate.bytesBeforeUnwritable();
    }

    public long bytesBeforeWritable() {
        return this.delegate.bytesBeforeWritable();
    }

    public Channel.Unsafe unsafe() {
        return this.delegate.unsafe();
    }

    public ChannelPipeline pipeline() {
        return this.delegate.pipeline();
    }

    public ByteBufAllocator alloc() {
        return this.delegate.alloc();
    }

    public Channel read() {
        return this.delegate.read();
    }

    public Channel flush() {
        return this.delegate.flush();
    }

    public Channel bypassDelay() {
        return this.delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelFuture write(Object msg, ChannelPromise promise) {
        DelayableWriteChannel delayableWriteChannel = this;
        synchronized (delayableWriteChannel) {
            if (this.delay != null) {
                this.delay.add(msg, () -> this.delegate.write(msg, promise));
                return promise;
            }
        }
        return this.delegate.write(msg, promise);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelFuture writeAndFlush(Object msg, ChannelPromise promise) {
        DelayableWriteChannel delayableWriteChannel = this;
        synchronized (delayableWriteChannel) {
            if (this.delay != null) {
                this.delay.add(msg, () -> this.delegate.writeAndFlush(msg, promise));
                return promise;
            }
        }
        return this.delegate.writeAndFlush(msg, promise);
    }

    public synchronized void discardDelayedWrites() {
        if (this.delay != null) {
            DelayedWrites parent = this.delay.previous;
            while (parent != null) {
                parent.discard();
                parent = parent.previous;
            }
            this.delay.discard();
            this.delay = null;
        }
    }

    public synchronized void writePendingMessages(DelayedWrites delayedWrites) {
        if (this.delay == delayedWrites) {
            this.delay = null;
        }
        delayedWrites.writeDelayed();
    }

    public synchronized void writePendingMessages() {
        if (this.delay == null) {
            return;
        }
        DelayedWrites previous = this.delay.previous;
        if (previous == null) {
            this.delay.writeDelayed();
            this.delay = null;
            return;
        }
        ArrayList<DelayedWrites> delayedWrites = new ArrayList<DelayedWrites>();
        delayedWrites.add(this.delay);
        this.delay = null;
        while (previous != null) {
            delayedWrites.add(previous);
            previous = previous.previous;
        }
        for (int i = delayedWrites.size() - 1; i >= 0; --i) {
            ((DelayedWrites)delayedWrites.get(i)).writeDelayed();
        }
    }

    public synchronized DelayedWrites delayWrites() {
        DelayedWrites delayedWrites;
        this.delay = delayedWrites = new DelayedWrites(this.delay);
        return delayedWrites;
    }

    static class DelayedWrites {
        private final ArrayDeque<DelayedMsg> delayed = new ArrayDeque();
        private final DelayedWrites previous;

        public DelayedWrites(@Nullable DelayedWrites previous) {
            this.previous = previous;
        }

        public void discard() {
            DelayedMsg delayedMsg;
            while ((delayedMsg = this.delayed.poll()) != null) {
                ReferenceCountUtil.safeRelease((Object)delayedMsg.msg);
            }
        }

        public void add(Object msg, Runnable runnable) {
            this.delayed.add(new DelayedMsg(msg, runnable));
        }

        private void writeDelayed() {
            DelayedMsg delayedMsg;
            while ((delayedMsg = this.delayed.poll()) != null) {
                delayedMsg.runnable.run();
            }
        }
    }

    record DelayedMsg(Object msg, Runnable runnable) {
    }
}

