/*
 * Decompiled with CFR 0.152.
 */
package io.crate.protocols.postgres;

import io.crate.action.FutureActionListener;
import io.crate.netty.NettyBootstrap;
import io.crate.protocols.postgres.ClientMessages;
import io.crate.protocols.postgres.KeyData;
import io.crate.protocols.postgres.PostgresWireProtocol;
import io.crate.protocols.ssl.SslContextProvider;
import io.crate.replication.logical.metadata.ConnectionInfo;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.store.AlreadyClosedException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.support.AbstractClient;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.network.CloseableChannel;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.util.PageCacheRecycler;
import org.elasticsearch.transport.CloseableConnection;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.ConnectionProfile;
import org.elasticsearch.transport.NodeNotConnectedException;
import org.elasticsearch.transport.OutboundHandler;
import org.elasticsearch.transport.ProxyConnection;
import org.elasticsearch.transport.RemoteClusterAwareRequest;
import org.elasticsearch.transport.RemoteConnectionParser;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.transport.TransportSettings;
import org.elasticsearch.transport.netty4.Netty4MessageChannelHandler;
import org.elasticsearch.transport.netty4.Netty4Transport;
import org.elasticsearch.transport.netty4.Netty4Utils;

public class PgClient
extends AbstractClient {
    private static final Logger LOGGER = LogManager.getLogger(PgClient.class);
    final String name;
    final NettyBootstrap nettyBootstrap;
    final Netty4Transport transport;
    final PageCacheRecycler pageCacheRecycler;
    final DiscoveryNode host;
    final TransportService transportService;
    final AtomicBoolean isClosing = new AtomicBoolean(false);
    final ConnectionInfo connectionInfo;
    final ConnectionProfile profile;
    final SslContextProvider sslContextProvider;
    private CompletableFuture<Transport.Connection> connectionFuture;

    public PgClient(String name, Settings nodeSettings, TransportService transportService, NettyBootstrap nettyBootstrap, Netty4Transport transport, SslContextProvider sslContextProvider, PageCacheRecycler pageCacheRecycler, ConnectionInfo connectionInfo) {
        super(nodeSettings, transport.getThreadPool());
        this.name = name;
        this.transportService = transportService;
        this.nettyBootstrap = nettyBootstrap;
        this.transport = transport;
        this.sslContextProvider = sslContextProvider;
        this.pageCacheRecycler = pageCacheRecycler;
        this.host = this.toDiscoveryNode(connectionInfo.hosts());
        this.connectionInfo = connectionInfo;
        this.profile = new ConnectionProfile.Builder().setConnectTimeout(TransportSettings.CONNECT_TIMEOUT.get(this.settings)).setHandshakeTimeout(TransportSettings.CONNECT_TIMEOUT.get(this.settings)).setPingInterval(TransportSettings.PING_SCHEDULE.get(this.settings)).setCompressionEnabled(TransportSettings.TRANSPORT_COMPRESS.get(this.settings)).addConnections(1, TransportRequestOptions.Type.BULK).addConnections(1, TransportRequestOptions.Type.PING).addConnections(1, TransportRequestOptions.Type.STATE).addConnections(1, TransportRequestOptions.Type.RECOVERY).addConnections(1, TransportRequestOptions.Type.REG).build();
    }

    private DiscoveryNode toDiscoveryNode(List<String> hosts) {
        if (hosts.isEmpty()) {
            throw new IllegalArgumentException("No hosts configured for pg tunnel " + this.name);
        }
        String host = hosts.get(0);
        TransportAddress transportAddress = new TransportAddress(RemoteConnectionParser.parseConfiguredAddress(host));
        return new DiscoveryNode("pg_tunnel_to=" + this.name + "#" + transportAddress.toString(), transportAddress, Version.CURRENT.minimumCompatibilityVersion());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Transport.Connection> ensureConnected() {
        CompletableFuture<Transport.Connection> future;
        if (this.isClosing.get()) {
            return CompletableFuture.failedFuture(new AlreadyClosedException("PgClient is closed"));
        }
        PgClient pgClient = this;
        synchronized (pgClient) {
            if (this.connectionFuture == null) {
                future = this.connectionFuture = new CompletableFuture();
            } else if (this.connectionFuture.isCompletedExceptionally() || this.connectionFuture.isDone() && this.connectionFuture.join().isClosed()) {
                future = this.connectionFuture = new CompletableFuture();
            } else {
                return this.connectionFuture;
            }
        }
        try {
            return this.connect(future);
        }
        catch (Throwable t) {
            future.completeExceptionally(t);
            return future;
        }
    }

    public CompletableFuture<Transport.Connection> connect(CompletableFuture<Transport.Connection> future) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Connecting to {}", (Object)this.host);
        }
        Bootstrap bootstrap = new Bootstrap();
        EventLoopGroup eventLoopGroup = this.nettyBootstrap.getSharedEventLoopGroup();
        bootstrap.group(eventLoopGroup);
        bootstrap.channel(NettyBootstrap.clientChannel());
        bootstrap.option(ChannelOption.TCP_NODELAY, (Object)TransportSettings.TCP_NO_DELAY.get(this.settings));
        bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)TransportSettings.TCP_KEEP_ALIVE.get(this.settings));
        bootstrap.handler((ChannelHandler)new ClientChannelInitializer(this.profile, this.host, this.transport, this.pageCacheRecycler, this.sslContextProvider, this.connectionInfo, future));
        bootstrap.remoteAddress((SocketAddress)this.host.getAddress().address());
        ChannelFuture connectFuture = bootstrap.connect();
        Channel channel = connectFuture.channel();
        future.exceptionally(err -> {
            try {
                Netty4Utils.closeChannels(List.of(channel));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        });
        CloseableChannel nettyChannel = new CloseableChannel(channel, false);
        channel.attr(Netty4Transport.CHANNEL_KEY).set((Object)nettyChannel);
        connectFuture.addListener(f -> {
            if (f.isSuccess()) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Connection to {} via pgwire established. Sending startup to switchover to transport protocol", (Object)this.host);
                }
                ByteBuf buffer = channel.alloc().buffer();
                ConnectionInfo.SSLMode sslMode = this.connectionInfo.sslMode();
                if (sslMode == ConnectionInfo.SSLMode.REQUIRE || sslMode == ConnectionInfo.SSLMode.PREFER) {
                    ClientMessages.writeSSLReqMessage(buffer);
                } else {
                    String user = this.connectionInfo.user();
                    Map<String, String> properties = Map.of("user", user, "CrateDBTransport", "true");
                    ClientMessages.sendStartupMessage(buffer, "doc", properties);
                }
                channel.writeAndFlush((Object)buffer);
            } else {
                future.completeExceptionally(f.cause());
            }
        });
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.isClosing.compareAndSet(false, true)) {
            CompletableFuture<Transport.Connection> future;
            PgClient pgClient = this;
            synchronized (pgClient) {
                future = this.connectionFuture;
                this.connectionFuture = null;
            }
            if (future != null) {
                future.thenAccept(conn -> conn.close());
            }
        }
    }

    public <Request extends TransportRequest, Response extends TransportResponse> CompletableFuture<Response> execute(ActionType<Response> action, Request request) {
        return this.ensureConnected().thenCompose(connection -> {
            FutureActionListener future = new FutureActionListener();
            if (request instanceof RemoteClusterAwareRequest) {
                RemoteClusterAwareRequest remoteClusterAware = (RemoteClusterAwareRequest)((Object)request);
                DiscoveryNode targetNode = remoteClusterAware.getPreferredTargetNode();
                this.transportService.sendRequest(new ProxyConnection((Transport.Connection)connection, targetNode), action.name(), request, TransportRequestOptions.EMPTY, new ActionListenerResponseHandler(future, action.getResponseReader()));
            } else {
                this.transportService.sendRequest((Transport.Connection)connection, action.name(), request, TransportRequestOptions.EMPTY, new ActionListenerResponseHandler(future, action.getResponseReader()));
            }
            return future;
        });
    }

    static class ClientChannelInitializer
    extends ChannelInitializer<Channel> {
        private final DiscoveryNode node;
        private final Netty4Transport transport;
        private final CompletableFuture<Transport.Connection> result;
        private final PageCacheRecycler pageCacheRecycler;
        private final ConnectionProfile profile;
        private final ConnectionInfo connectionInfo;
        private final SslContextProvider sslContextProvider;

        public ClientChannelInitializer(ConnectionProfile profile, DiscoveryNode node, Netty4Transport transport, PageCacheRecycler pageCacheRecycler, SslContextProvider sslContextProvider, ConnectionInfo connectionInfo, CompletableFuture<Transport.Connection> result) {
            this.profile = profile;
            this.node = node;
            this.transport = transport;
            this.pageCacheRecycler = pageCacheRecycler;
            this.sslContextProvider = sslContextProvider;
            this.connectionInfo = connectionInfo;
            this.result = result;
        }

        protected void initChannel(Channel ch) throws Exception {
            ChannelPipeline pipeline = ch.pipeline();
            ConnectionInfo.SSLMode sslMode = this.connectionInfo.sslMode();
            SslContext sslCtx = null;
            if (sslMode == ConnectionInfo.SSLMode.REQUIRE || sslMode == ConnectionInfo.SSLMode.PREFER) {
                try {
                    sslCtx = this.sslContextProvider.clientContext();
                }
                catch (Exception e) {
                    sslCtx = SslContextBuilder.forClient().build();
                }
            }
            pipeline.addLast("decoder", (ChannelHandler)new Decoder(this.connectionInfo.user(), sslMode, sslCtx));
            Handler handler = new Handler(this.profile, this.node, this.transport, this.pageCacheRecycler, this.connectionInfo, this.result);
            ch.pipeline().addLast("dispatcher", (ChannelHandler)handler);
        }
    }

    public static class TunneledConnection
    extends CloseableConnection {
        private final DiscoveryNode node;
        private final CloseableChannel channel;
        private final ConnectionProfile connectionProfile;
        private final Version version;
        private final OutboundHandler outboundHandler;
        private final AtomicBoolean isClosing = new AtomicBoolean(false);

        public TunneledConnection(OutboundHandler outboundHandler, DiscoveryNode node, CloseableChannel channel, ConnectionProfile connectionProfile, Version version) {
            this.outboundHandler = outboundHandler;
            this.node = node;
            this.channel = channel;
            this.connectionProfile = connectionProfile;
            this.version = version;
        }

        @Override
        public DiscoveryNode getNode() {
            return this.node;
        }

        @Override
        public void sendRequest(long requestId, String action, TransportRequest request, TransportRequestOptions options) throws IOException, TransportException {
            if (this.isClosing.get()) {
                throw new NodeNotConnectedException(this.node, "connection already closed");
            }
            this.outboundHandler.sendRequest(this.node, this.channel, requestId, action, request, options, this.version, this.connectionProfile.getCompressionEnabled(), false);
        }

        @Override
        public void close() {
            if (this.isClosing.compareAndSet(false, true)) {
                try {
                    CloseableChannel.closeChannels(List.of(this.channel), false);
                }
                finally {
                    super.close();
                }
            }
        }
    }

    static class Decoder
    extends ByteToMessageDecoder {
        private static final int HEADER_LENGTH = 5;
        private final SslContext sslContext;
        private final String user;
        private final ConnectionInfo.SSLMode sslMode;
        private boolean expectSSLResponse;

        public Decoder(String user, ConnectionInfo.SSLMode sslMode, SslContext sslContext) {
            this.user = user;
            this.sslMode = sslMode;
            this.sslContext = sslContext;
            this.expectSSLResponse = sslMode == ConnectionInfo.SSLMode.REQUIRE || sslMode == ConnectionInfo.SSLMode.PREFER;
        }

        protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
            ByteBuf buf = this.decode(ctx, in);
            if (buf != null) {
                out.add(buf);
            }
        }

        private ByteBuf decode(ChannelHandlerContext ctx, ByteBuf in) {
            if (this.expectSSLResponse) {
                if (in.readableBytes() < 1) {
                    return null;
                }
                this.expectSSLResponse = false;
                byte sslResponse = in.readByte();
                if (sslResponse == 83) {
                    this.injectSSLHandler(ctx);
                    this.sendStartup(ctx);
                } else if (sslResponse == 78) {
                    if (this.sslMode == ConnectionInfo.SSLMode.REQUIRE) {
                        throw new IllegalStateException("SSL required but not supported");
                    }
                    this.sendStartup(ctx);
                } else {
                    throw new IllegalStateException("Unexpected SSL response: " + sslResponse);
                }
            }
            if (in.readableBytes() < 5) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("PgDecoder needs more bytes readableBytes={}", (Object)in.readableBytes());
                }
                return null;
            }
            in.markReaderIndex();
            byte msgType = in.readByte();
            int msgLength = in.readInt() - 4;
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Decoding message type={} length={} readableBytes={}", (Object)Character.valueOf((char)msgType), (Object)msgLength, (Object)in.readableBytes());
            }
            if (in.readableBytes() < msgLength) {
                in.resetReaderIndex();
                return null;
            }
            in.resetReaderIndex();
            return in.readBytes(5 + msgLength);
        }

        private void injectSSLHandler(ChannelHandlerContext ctx) {
            ChannelPipeline pipeline = ctx.pipeline();
            SslHandler sslHandler = this.sslContext.newHandler(ctx.alloc());
            pipeline.addFirst(new ChannelHandler[]{sslHandler});
        }

        private void sendStartup(ChannelHandlerContext ctx) {
            ByteBuf buffer = ctx.alloc().buffer();
            Map<String, String> properties = Map.of("user", this.user, "CrateDBTransport", "true");
            ClientMessages.sendStartupMessage(buffer, "doc", properties);
            ChannelFuture flushStartup = ctx.writeAndFlush((Object)buffer);
            if (LOGGER.isWarnEnabled()) {
                flushStartup.addListener(f -> {
                    if (!f.isSuccess()) {
                        LOGGER.warn("Client failed to send startup message", f.cause());
                    }
                });
            }
        }
    }

    static enum AuthType {
        OK,
        CLEARTEXT_PASSWORD;


        public static AuthType of(int type) {
            return switch (type) {
                case 0 -> OK;
                case 3 -> CLEARTEXT_PASSWORD;
                default -> throw new IllegalArgumentException("Unknown auth type: " + type);
            };
        }
    }

    static class Handler
    extends SimpleChannelInboundHandler<ByteBuf> {
        private final CompletableFuture<Transport.Connection> result;
        private final PageCacheRecycler pageCacheRecycler;
        private final DiscoveryNode node;
        private final Netty4Transport transport;
        private final ConnectionProfile profile;
        private final ConnectionInfo connectionInfo;

        public Handler(ConnectionProfile profile, DiscoveryNode node, Netty4Transport transport, PageCacheRecycler pageCacheRecycler, ConnectionInfo connectionInfo, CompletableFuture<Transport.Connection> result) {
            this.profile = profile;
            this.node = node;
            this.transport = transport;
            this.pageCacheRecycler = pageCacheRecycler;
            this.connectionInfo = connectionInfo;
            this.result = result;
        }

        public boolean acceptInboundMessage(Object msg) throws Exception {
            return true;
        }

        protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
            byte msgType = msg.readByte();
            msg.readInt();
            switch (msgType) {
                case 82: {
                    this.handleAuth(ctx.channel(), msg);
                    break;
                }
                case 83: {
                    this.handleParameterStatus(msg);
                    break;
                }
                case 90: {
                    this.handleReadyForQuery(ctx.channel(), msg);
                    break;
                }
                case 69: {
                    this.handleErrorResponse(msg);
                    break;
                }
                case 75: {
                    this.handleKeyData(msg);
                    break;
                }
                default: {
                    this.result.completeExceptionally(new IllegalStateException("Unexpected message type: " + msgType));
                }
            }
        }

        private void handleErrorResponse(ByteBuf msg) {
            ArrayList<String> errorMessages = new ArrayList<String>();
            while (msg.readByte() != 0) {
                String error = PostgresWireProtocol.readCString(msg);
                errorMessages.add(error);
            }
            this.result.completeExceptionally(new IllegalStateException("Error response: " + String.join((CharSequence)", ", errorMessages)));
        }

        private void handleKeyData(ByteBuf msg) {
            KeyData.of(msg);
        }

        private void handleReadyForQuery(Channel channel, ByteBuf msg) {
            msg.readByte();
            this.upgradeToTransportProtocol(channel);
        }

        private void upgradeToTransportProtocol(Channel channel) {
            channel.pipeline().remove("decoder");
            channel.pipeline().remove("dispatcher");
            Netty4MessageChannelHandler handler = new Netty4MessageChannelHandler(this.pageCacheRecycler, this.transport);
            channel.pipeline().addLast("dispatcher", (ChannelHandler)handler);
            CloseableChannel tcpChannel = (CloseableChannel)channel.attr(Netty4Transport.CHANNEL_KEY).get();
            ActionListener<Version> onHandshakeResponse = ActionListener.wrap(version -> {
                TunneledConnection connection = new TunneledConnection(this.transport.outboundHandler(), this.node, tcpChannel, this.profile, (Version)version);
                long relativeMillisTime = this.transport.getThreadPool().relativeTimeInMillis();
                tcpChannel.markAccessed(relativeMillisTime);
                tcpChannel.addCloseListener(ActionListener.wrap(connection::close));
                this.result.complete(connection);
            }, e -> {
                Exception error = e instanceof ConnectTransportException ? e : new ConnectTransportException(this.node, "general node connection failure", (Throwable)e);
                try {
                    CloseableChannel.closeChannels(List.of(tcpChannel), false);
                }
                catch (Exception ex) {
                    error.addSuppressed(ex);
                }
                finally {
                    this.result.completeExceptionally(error);
                }
            });
            this.transport.executeHandshake(this.node, tcpChannel, this.profile, onHandshakeResponse);
        }

        private void handleParameterStatus(ByteBuf msg) {
            PostgresWireProtocol.readCString(msg);
            PostgresWireProtocol.readCString(msg);
        }

        private void handleAuth(Channel channel, ByteBuf msg) {
            AuthType authType = AuthType.of(msg.readInt());
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Server sent authentication request type={}", (Object)authType);
            }
            switch (authType.ordinal()) {
                case 0: {
                    break;
                }
                case 1: {
                    ByteBuf buffer = channel.alloc().buffer();
                    ClientMessages.writePasswordMessage(buffer, this.connectionInfo.password());
                    channel.writeAndFlush((Object)buffer);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(String.valueOf((Object)authType) + " is not supported");
                }
            }
        }
    }
}

