/*
 * Decompiled with CFR 0.152.
 */
package io.crate.protocols.postgres.types;

import io.crate.protocols.postgres.types.PGType;
import io.netty.buffer.ByteBuf;
import org.jetbrains.annotations.NotNull;

abstract class BaseTimestampType
extends PGType<Long> {
    protected static final int TYPE_LEN = 8;
    protected static final int TYPE_MOD = -1;
    protected static final long FIRST_MSEC_AFTER_CHRIST = -62135596800000L;
    private static final long EPOCH_DIFF_IN_MS = 946684800000L;

    BaseTimestampType(int oid, int typeLen, int typeMod, @NotNull String typeName) {
        super(oid, typeLen, typeMod, typeName);
    }

    @Override
    public int writeAsBinary(ByteBuf buffer, @NotNull Long value) {
        buffer.writeInt(8);
        buffer.writeLong(BaseTimestampType.toPgTimestamp(value));
        return 12;
    }

    @Override
    public String typeCategory() {
        return PGType.TypeCategory.DATETIME.code();
    }

    @Override
    public String type() {
        return PGType.Type.BASE.code();
    }

    private static long toPgTimestamp(long unixTsInMs) {
        return (unixTsInMs - 946684800000L) * 1000L;
    }

    @Override
    public Long readBinaryValue(ByteBuf buffer, int valueLength) {
        assert (valueLength == 8) : "valueLength must be 8 because timestamp is a 64 bit long. Actual length: " + valueLength;
        long microSecondsSince2K = buffer.readLong();
        return BaseTimestampType.toCrateTimestamp(microSecondsSince2K);
    }

    private static long toCrateTimestamp(long microSecondsSince2k) {
        return microSecondsSince2k / 1000L + 946684800000L;
    }
}

