/*
 * Decompiled with CFR 0.152.
 */
package io.crate.protocols.postgres.types;

import io.crate.protocols.postgres.types.PGArray;
import io.crate.protocols.postgres.types.PGType;
import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class BooleanType
extends PGType<Boolean> {
    public static final BooleanType INSTANCE = new BooleanType();
    static final int OID = 16;
    private static final int TYPE_LEN = 1;
    private static final int TYPE_MOD = -1;
    private static final byte[] TEXT_TRUE = new byte[]{116};
    private static final byte[] TEXT_FALSE = new byte[]{102};
    private static final Collection<ByteBuffer> TRUTH_VALUES = Set.of(ByteBuffer.wrap(new byte[]{49}), ByteBuffer.wrap(new byte[]{116}), ByteBuffer.wrap(new byte[]{84}), ByteBuffer.wrap(new byte[]{116, 114, 117, 101}), ByteBuffer.wrap(new byte[]{84, 82, 85, 69}));

    private BooleanType() {
        super(16, 1, -1, "bool");
    }

    @Override
    public int typArray() {
        return PGArray.BOOL_ARRAY.oid();
    }

    @Override
    public String typeCategory() {
        return PGType.TypeCategory.NUMERIC.code();
    }

    @Override
    public String type() {
        return PGType.Type.BASE.code();
    }

    @Override
    public int writeAsBinary(ByteBuf buffer, @NotNull Boolean value) {
        byte byteValue = (byte)(value != false ? 1 : 0);
        buffer.writeInt(1);
        buffer.writeByte((int)byteValue);
        return 5;
    }

    @Override
    byte[] encodeAsUTF8Text(@NotNull Boolean value) {
        return value != false ? TEXT_TRUE : TEXT_FALSE;
    }

    @Override
    public Boolean readBinaryValue(ByteBuf buffer, int valueLength) {
        assert (valueLength == 1) : "length should be 1 because boolean is just a byte. Actual length: " + valueLength;
        byte value = buffer.readByte();
        switch (value) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        throw new IllegalArgumentException("Unsupported binary bool: " + value);
    }

    @Override
    Boolean decodeUTF8Text(byte[] bytes) {
        return TRUTH_VALUES.contains(ByteBuffer.wrap(bytes));
    }
}

