/*
 * Decompiled with CFR 0.152.
 */
package io.crate.protocols.postgres.types;

import com.carrotsearch.hppc.ByteArrayList;
import io.crate.protocols.postgres.parser.PgArrayParser;
import io.crate.protocols.postgres.types.PGArray;
import io.crate.protocols.postgres.types.PGType;
import io.crate.protocols.postgres.types.RealType;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PGFloatVectorType
extends PGType<float[]> {
    public static final PGFloatVectorType INSTANCE = new PGFloatVectorType();

    PGFloatVectorType() {
        super(PGArray.FLOAT4_ARRAY.oid(), -1, -1, PGArray.FLOAT4_ARRAY.typName());
    }

    @Override
    public int typArray() {
        return 0;
    }

    @Override
    public int typElem() {
        return PGArray.FLOAT4_ARRAY.typElem();
    }

    @Override
    public String typeCategory() {
        return PGArray.FLOAT4_ARRAY.typeCategory();
    }

    @Override
    public String type() {
        return PGArray.FLOAT4_ARRAY.type();
    }

    @Override
    public int writeAsBinary(ByteBuf buffer, @NotNull float[] value) {
        int arrayLength = value.length;
        int lenIndex = buffer.writerIndex();
        buffer.writeInt(0);
        buffer.writeInt(1);
        buffer.writeInt(0);
        buffer.writeInt(this.typElem());
        buffer.writeInt(arrayLength);
        buffer.writeInt(arrayLength);
        int bytesWritten = 20;
        int len = bytesWritten + this.writeArrayAsBinary(buffer, value);
        buffer.setInt(lenIndex, len);
        return 4 + len;
    }

    @Override
    public float[] readBinaryValue(ByteBuf buffer, int valueLength) {
        int dimensions = buffer.readInt();
        assert (dimensions == 1) : "float_vector should have only 1 dimension";
        buffer.readInt();
        buffer.readInt();
        int dimension = buffer.readInt();
        buffer.readInt();
        return PGFloatVectorType.readArrayAsBinary(buffer, dimension);
    }

    @Override
    byte[] encodeAsUTF8Text(float[] value) {
        ByteArrayList encodedValues = new ByteArrayList();
        encodedValues.add((byte)123);
        for (int i = 0; i < value.length; ++i) {
            float f = value[i];
            if (i > 0) {
                encodedValues.add((byte)44);
            }
            byte[] bytes = RealType.INSTANCE.encodeAsUTF8Text(Float.valueOf(f));
            encodedValues.add((byte)34);
            encodedValues.add(bytes);
            encodedValues.add((byte)34);
        }
        encodedValues.add((byte)125);
        return Arrays.copyOfRange(encodedValues.buffer, 0, encodedValues.elementsCount);
    }

    @Override
    float[] decodeUTF8Text(byte[] bytes) {
        List list = (List)PgArrayParser.parse((byte[])bytes, RealType.INSTANCE::decodeUTF8Text);
        float[] vector = new float[list.size()];
        for (int i = 0; i < vector.length; ++i) {
            vector[i] = ((Float)list.get(i)).floatValue();
        }
        return vector;
    }

    private int writeArrayAsBinary(ByteBuf buffer, @NotNull float[] array) {
        int bytesWritten = 0;
        for (float f : array) {
            bytesWritten += RealType.INSTANCE.writeAsBinary(buffer, Float.valueOf(f));
        }
        return bytesWritten;
    }

    static float[] readArrayAsBinary(ByteBuf buffer, int dimension) {
        float[] array = new float[dimension];
        for (int i = 0; i < dimension; ++i) {
            int len = buffer.readInt();
            array[i] = RealType.INSTANCE.readBinaryValue(buffer, len).floatValue();
        }
        return array;
    }
}

