/*
 * Decompiled with CFR 0.152.
 */
package io.crate.protocols.postgres.types;

import io.crate.protocols.postgres.types.BaseTimestampType;
import io.crate.protocols.postgres.types.PGArray;
import io.crate.types.Regproc;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

final class TimestampType
extends BaseTimestampType {
    public static final TimestampType INSTANCE = new TimestampType();
    private static final int OID = 1114;
    private static final String NAME = "timestamp";
    private static final DateTimeFormatter PARSER_WITH_OPTIONAL_ERA = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).optionalStart().appendLiteral(' ').append(DateTimeFormatter.ISO_LOCAL_TIME).optionalStart().appendPattern("[VV][x][xx][xxx]").optionalStart().appendLiteral(' ').appendPattern("G").toFormatter(Locale.ENGLISH).withResolverStyle(ResolverStyle.STRICT);
    private static final DateTimeFormatter ISO_FORMATTER = new DateTimeFormatterBuilder().parseCaseInsensitive().appendPattern("yyyy-MM-dd HH:mm:ss.SSS+00").toFormatter(Locale.ENGLISH).withResolverStyle(ResolverStyle.STRICT);
    private static final DateTimeFormatter ISO_FORMATTER_WITH_ERA = new DateTimeFormatterBuilder().parseCaseInsensitive().append(ISO_FORMATTER).appendLiteral(' ').appendPattern("G").toFormatter(Locale.ENGLISH).withResolverStyle(ResolverStyle.STRICT);

    private TimestampType() {
        super(1114, 8, -1, NAME);
    }

    @Override
    public int typArray() {
        return PGArray.TIMESTAMP_ARRAY.oid();
    }

    @Override
    public Regproc typSend() {
        return Regproc.of("timestamp_send");
    }

    @Override
    public Regproc typReceive() {
        return Regproc.of("timestamp_recv");
    }

    @Override
    byte[] encodeAsUTF8Text(@NotNull Long value) {
        long millis = value;
        LocalDateTime ts = LocalDateTime.ofInstant(Instant.ofEpochMilli(millis), ZoneOffset.UTC);
        if (millis >= -62135596800000L) {
            return ts.format(ISO_FORMATTER).getBytes(StandardCharsets.UTF_8);
        }
        return ts.format(ISO_FORMATTER_WITH_ERA).getBytes(StandardCharsets.UTF_8);
    }

    @Override
    Long decodeUTF8Text(byte[] bytes) {
        String s = new String(bytes, StandardCharsets.UTF_8);
        try {
            LocalDateTime dt = LocalDateTime.parse(s, PARSER_WITH_OPTIONAL_ERA);
            return dt.toInstant(ZoneOffset.UTC).toEpochMilli();
        }
        catch (Exception e) {
            return io.crate.types.TimestampType.parseTimestampIgnoreTimeZone(s);
        }
    }
}

