/*
 * Decompiled with CFR 0.152.
 */
package io.crate.protocols.postgres.types;

import io.crate.protocols.postgres.types.PGType;
import io.crate.types.DataTypes;
import io.crate.types.Regproc;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;

public class UnknownType
extends PGType<Object> {
    public static final UnknownType INSTANCE = new UnknownType();
    static final int OID = 705;

    UnknownType() {
        super(705, -2, -1, "unknown");
    }

    @Override
    public int typArray() {
        return 0;
    }

    @Override
    public String typeCategory() {
        return PGType.TypeCategory.UNKNOWN.code();
    }

    @Override
    public String type() {
        return PGType.Type.PSEUDO.code();
    }

    @Override
    public Regproc typReceive() {
        return Regproc.of("unknownrecv");
    }

    @Override
    public Regproc typSend() {
        return Regproc.of("unknownsend");
    }

    @Override
    public Regproc typOutput() {
        return Regproc.of("unknownout");
    }

    @Override
    public Regproc typInput() {
        return Regproc.of("unknownin");
    }

    @Override
    public int writeAsBinary(ByteBuf buffer, @NotNull Object value) {
        String string = DataTypes.STRING.implicitCast(value);
        int writerIndex = buffer.writerIndex();
        buffer.writeInt(0);
        int bytesWritten = buffer.writeCharSequence((CharSequence)string, StandardCharsets.UTF_8);
        buffer.setInt(writerIndex, bytesWritten);
        return 4 + bytesWritten;
    }

    @Override
    public String readBinaryValue(ByteBuf buffer, int valueLength) {
        int readerIndex = buffer.readerIndex();
        buffer.readerIndex(readerIndex + valueLength);
        return buffer.toString(readerIndex, valueLength, StandardCharsets.UTF_8);
    }

    @Override
    byte[] encodeAsUTF8Text(@NotNull Object value) {
        return DataTypes.STRING.implicitCast(value).getBytes(StandardCharsets.UTF_8);
    }

    @Override
    String decodeUTF8Text(byte[] bytes) {
        return new String(bytes, StandardCharsets.UTF_8);
    }
}

