/*
 * Decompiled with CFR 0.152.
 */
package io.crate.protocols.ssl;

import io.crate.auth.AuthSettings;
import io.crate.auth.Protocol;
import io.crate.common.Optionals;
import io.crate.protocols.ssl.SslConfigurationException;
import io.crate.protocols.ssl.SslSettings;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.settings.Settings;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Singleton
public class SslContextProvider
implements Supplier<SslContext> {
    private static final String TLS_VERSION = "TLSv1.2";
    private static final Logger LOGGER = LogManager.getLogger(SslContextProvider.class);
    private final Map<Protocol, SslContext> sslContextPerProtocol = new ConcurrentHashMap<Protocol, SslContext>();
    private final Settings settings;
    private final String keystorePath;
    private final char[] keystorePass;
    private final char[] keystoreKeyPass;
    private final String trustStorePath;
    private final char[] trustStorePass;

    @Inject
    public SslContextProvider(Settings settings) {
        this.settings = settings;
        this.keystorePath = SslSettings.SSL_KEYSTORE_FILEPATH.get(settings);
        this.keystorePass = SslSettings.SSL_KEYSTORE_PASSWORD.get(settings).toCharArray();
        this.keystoreKeyPass = SslSettings.SSL_KEYSTORE_KEY_PASSWORD.get(settings).toCharArray();
        this.trustStorePath = SslSettings.SSL_TRUSTSTORE_FILEPATH.get(settings);
        this.trustStorePass = SslSettings.SSL_TRUSTSTORE_PASSWORD.get(settings).toCharArray();
    }

    public SslContext getServerContext(Protocol protocol) {
        return this.sslContextPerProtocol.computeIfAbsent(protocol, p -> this.serverContext((Protocol)((Object)p)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadSslContext() {
        SslContextProvider sslContextProvider = this;
        synchronized (sslContextProvider) {
            this.sslContextPerProtocol.keySet().forEach(protocol -> this.sslContextPerProtocol.put((Protocol)((Object)protocol), this.serverContext((Protocol)((Object)protocol))));
            LOGGER.info("SSL configuration is reloaded.");
        }
    }

    @VisibleForTesting
    public SSLContext jdkSSLContext() throws Exception {
        KeyStore keyStore = SslContextProvider.loadKeyStore(this.keystorePath, this.keystorePass);
        KeyManager[] keyManagers = SslContextProvider.createKeyManagers(keyStore, this.keystoreKeyPass);
        KeyStore trustStore = Optionals.of(() -> SslContextProvider.loadKeyStore(this.trustStorePath, this.trustStorePass)).orElse(keyStore);
        TrustManager[] trustManagers = SslContextProvider.createTrustManagers(trustStore);
        SSLContext sslContext = SSLContext.getInstance(TLS_VERSION);
        sslContext.init(keyManagers, trustManagers, null);
        return sslContext;
    }

    public SslContext clientContext() {
        try {
            KeyStore keyStore = SslContextProvider.loadKeyStore(this.keystorePath, this.keystorePass);
            KeyManager[] keyManagers = SslContextProvider.createKeyManagers(keyStore, this.keystoreKeyPass);
            Optional trustStore = Optionals.of(() -> SslContextProvider.loadKeyStore(this.trustStorePath, this.trustStorePass));
            TrustManager[] trustManagers = trustStore.map(SslContextProvider::createTrustManagers).orElseGet(() -> SslContextProvider.createTrustManagers(null));
            SSLContext sslContext = SSLContext.getInstance(TLS_VERSION);
            sslContext.init(keyManagers, trustManagers, null);
            X509Certificate[] keyStoreRootCerts = SslContextProvider.getRootCertificates(keyStore);
            X509Certificate[] trustStoreRootCerts = trustStore.map(SslContextProvider::getRootCertificates).orElseGet(() -> SslContextProvider.getDefaultCertificates(trustManagers));
            return SslContextBuilder.forClient().keyManager(this.getKey(keyStore, this.keystoreKeyPass), SslContextProvider.getCertificateChain(keyStore)).ciphers(List.of(sslContext.createSSLEngine().getEnabledCipherSuites())).applicationProtocolConfig(ApplicationProtocolConfig.DISABLED).trustManager(SslContextProvider.concat(keyStoreRootCerts, trustStoreRootCerts)).sessionCacheSize(0L).sessionTimeout(0L).startTls(false).sslProvider(SslProvider.JDK).build();
        }
        catch (SslConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SslConfigurationException("Failed to build SSL configuration: " + e.getMessage(), e);
        }
    }

    @Nullable
    private PrivateKey getKey(KeyStore keyStore, char[] password) throws Exception {
        Enumeration<String> aliases = keyStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            Key key = keyStore.getKey(alias, password);
            if (!(key instanceof PrivateKey)) continue;
            PrivateKey privateKey = (PrivateKey)key;
            return privateKey;
        }
        return null;
    }

    private SslContext serverContext(Protocol protocol) {
        try {
            KeyStore keyStore = SslContextProvider.loadKeyStore(this.keystorePath, this.keystorePass);
            KeyManager[] keyManagers = SslContextProvider.createKeyManagers(keyStore, this.keystoreKeyPass);
            Optional trustStore = Optionals.of(() -> SslContextProvider.loadKeyStore(this.trustStorePath, this.trustStorePass));
            TrustManager[] trustManagers = trustStore.map(SslContextProvider::createTrustManagers).orElseGet(() -> new TrustManager[0]);
            SSLContext sslContext = SSLContext.getInstance(TLS_VERSION);
            sslContext.init(keyManagers, trustManagers, null);
            X509Certificate[] keyStoreCertChain = SslContextProvider.getCertificateChain(keyStore);
            X509Certificate[] trustStoreRootCerts = trustStore.map(SslContextProvider::getRootCertificates).orElseGet(() -> new X509Certificate[0]);
            PrivateKey privateKey = SslContextProvider.getPrivateKey(keyStore, this.keystoreKeyPass);
            return SslContextBuilder.forServer((PrivateKey)privateKey, (X509Certificate[])keyStoreCertChain).ciphers(List.of(sslContext.createSSLEngine().getEnabledCipherSuites())).applicationProtocolConfig(ApplicationProtocolConfig.DISABLED).clientAuth(AuthSettings.resolveClientAuth(this.settings, protocol)).trustManager(SslContextProvider.concat(keyStoreCertChain, trustStoreRootCerts)).sessionCacheSize(0L).sessionTimeout(0L).startTls(false).sslProvider(SslProvider.JDK).build();
        }
        catch (SslConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SslConfigurationException("Failed to build SSL configuration: " + e.getMessage(), e);
        }
    }

    static KeyStore loadKeyStore(String path, char[] pass) throws Exception {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(path));){
            keyStore.load(stream, pass);
        }
        return keyStore;
    }

    static KeyManager[] createKeyManagers(KeyStore keyStore, char[] pass) throws Exception {
        KeyManagerFactory keyFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyFactory.init(keyStore, pass);
        return keyFactory.getKeyManagers();
    }

    static TrustManager[] createTrustManagers(@Nullable KeyStore keyStore) {
        TrustManagerFactory trustFactory;
        try {
            trustFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustFactory.init(keyStore);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return trustFactory.getTrustManagers();
    }

    private static <T> T[] concat(T[] xs, T[] ys) {
        T[] result = Arrays.copyOf(xs, xs.length + ys.length);
        System.arraycopy(ys, 0, result, xs.length, ys.length);
        return result;
    }

    static X509Certificate[] getDefaultCertificates(TrustManager[] trustManagers) {
        return (X509Certificate[])Arrays.stream(trustManagers).flatMap(tm -> Arrays.stream(((X509TrustManager)tm).getAcceptedIssuers())).collect(Collectors.toList()).toArray(X509Certificate[]::new);
    }

    static X509Certificate[] getRootCertificates(KeyStore keyStore) {
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        try {
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                Certificate certificate = keyStore.getCertificate(alias);
                if (!(certificate instanceof X509Certificate)) continue;
                X509Certificate x509Cert = (X509Certificate)certificate;
                certs.add(x509Cert);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return certs.toArray(new X509Certificate[0]);
    }

    static X509Certificate[] getCertificateChain(KeyStore keyStore) {
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        try {
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                Certificate[] certificateChain;
                String alias = aliases.nextElement();
                if (!keyStore.isKeyEntry(alias) || (certificateChain = keyStore.getCertificateChain(alias)) == null) continue;
                for (Certificate certificate : certificateChain) {
                    certs.add((X509Certificate)certificate);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return certs.toArray(new X509Certificate[0]);
    }

    static PrivateKey getPrivateKey(KeyStore keyStore, char[] password) throws KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException {
        Enumeration<String> aliases = keyStore.aliases();
        while (aliases.hasMoreElements()) {
            Key key;
            String alias = aliases.nextElement();
            if (!keyStore.isKeyEntry(alias) || !((key = keyStore.getKey(alias, password)) instanceof PrivateKey)) continue;
            return (PrivateKey)key;
        }
        throw new KeyStoreException("No fitting private key found in keyStore");
    }

    @Override
    public SslContext get() {
        return this.getServerContext(Protocol.POSTGRES);
    }
}

