/*
 * Decompiled with CFR 0.152.
 */
package io.crate.protocols.ssl;

import io.crate.common.unit.TimeValue;
import io.crate.types.DataTypes;
import java.util.Locale;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;

public final class SslSettings {
    private static final String SSL_TRANSPORT_MODE_NAME = "ssl.transport.mode";
    private static final String SSL_HTTP_ENABLED_SETTING_NAME = "ssl.http.enabled";
    private static final String SSL_PSQL_ENABLED_SETTING_NAME = "ssl.psql.enabled";
    static final String SSL_TRUSTSTORE_FILEPATH_SETTING_NAME = "ssl.truststore_filepath";
    static final String SSL_TRUSTSTORE_PASSWORD_SETTING_NAME = "ssl.truststore_password";
    static final String SSL_KEYSTORE_FILEPATH_SETTING_NAME = "ssl.keystore_filepath";
    static final String SSL_KEYSTORE_PASSWORD_SETTING_NAME = "ssl.keystore_password";
    static final String SSL_KEYSTORE_KEY_PASSWORD_SETTING_NAME = "ssl.keystore_key_password";
    static final String SSL_RESOURCE_POLL_INTERVAL_NAME = "ssl.resource_poll_interval";
    public static final Setting<Boolean> SSL_HTTP_ENABLED = Setting.boolSetting("ssl.http.enabled", false, Setting.Property.NodeScope);
    public static final Setting<Boolean> SSL_PSQL_ENABLED = Setting.boolSetting("ssl.psql.enabled", false, Setting.Property.NodeScope);
    public static final Setting<SSLMode> SSL_TRANSPORT_MODE = new Setting<SSLMode>("ssl.transport.mode", settings -> SSLMode.LEGACY.name(), SSLMode::parse, DataTypes.STRING, Setting.Property.NodeScope);
    public static final Setting<String> SSL_TRUSTSTORE_FILEPATH = Setting.simpleString("ssl.truststore_filepath", Setting.Property.NodeScope);
    public static final Setting<String> SSL_TRUSTSTORE_PASSWORD = Setting.simpleString("ssl.truststore_password", Setting.Property.NodeScope);
    public static final Setting<String> SSL_KEYSTORE_FILEPATH = Setting.simpleString("ssl.keystore_filepath", Setting.Property.NodeScope);
    public static final Setting<String> SSL_KEYSTORE_PASSWORD = Setting.simpleString("ssl.keystore_password", "", Setting.Property.NodeScope);
    public static final Setting<String> SSL_KEYSTORE_KEY_PASSWORD = Setting.simpleString("ssl.keystore_key_password", Setting.Property.NodeScope);
    public static final Setting<TimeValue> SSL_RESOURCE_POLL_INTERVAL = Setting.positiveTimeSetting("ssl.resource_poll_interval", TimeValue.timeValueMinutes((long)5L), Setting.Property.NodeScope);

    private SslSettings() {
    }

    public static boolean isHttpsEnabled(Settings settings) {
        return SSL_HTTP_ENABLED.get(settings);
    }

    public static boolean isPSQLSslEnabled(Settings settings) {
        return SSL_PSQL_ENABLED.get(settings);
    }

    public static enum SSLMode {
        ON,
        OFF,
        LEGACY;


        static SSLMode parse(String value) {
            return switch (value.toLowerCase(Locale.ENGLISH)) {
                case "on" -> ON;
                case "true" -> ON;
                case "off" -> OFF;
                case "false" -> OFF;
                case "legacy" -> LEGACY;
                default -> throw new IllegalArgumentException(value + " is not a valid SSL mode setting");
            };
        }
    }
}

