/*
 * Decompiled with CFR 0.152.
 */
package io.crate.replication.logical;

import io.crate.concurrent.CountdownFuture;
import io.crate.exceptions.SQLExceptions;
import io.crate.execution.support.RetryRunnable;
import io.crate.metadata.IndexName;
import io.crate.metadata.IndexParts;
import io.crate.metadata.PartitionName;
import io.crate.metadata.RelationName;
import io.crate.replication.logical.LogicalReplicationService;
import io.crate.replication.logical.LogicalReplicationSettings;
import io.crate.replication.logical.action.DropSubscriptionAction;
import io.crate.replication.logical.action.PublicationsStateAction;
import io.crate.replication.logical.action.UpdateSubscriptionAction;
import io.crate.replication.logical.exceptions.SubscriptionUnknownException;
import io.crate.replication.logical.metadata.RelationMetadata;
import io.crate.replication.logical.metadata.Subscription;
import io.crate.replication.logical.metadata.SubscriptionsMetadata;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.bulk.BackoffPolicy;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataDeleteIndexService;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.threadpool.ThreadPool;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public final class MetadataTracker
implements Closeable {
    private static final Logger LOGGER = LogManager.getLogger(MetadataTracker.class);
    private final Settings settings;
    private final ThreadPool threadPool;
    private final LogicalReplicationService replicationService;
    private final LogicalReplicationSettings replicationSettings;
    private final Function<String, Client> remoteClient;
    private final ClusterService clusterService;
    private final IndexScopedSettings indexScopedSettings;
    private final AllocationService allocationService;
    private volatile Set<String> subscriptionsToTrack = Set.of();
    private volatile Scheduler.Cancellable cancellable;
    private volatile boolean isActive = false;

    public MetadataTracker(Settings settings, IndexScopedSettings indexScopedSettings, ThreadPool threadPool, LogicalReplicationService replicationService, LogicalReplicationSettings replicationSettings, Function<String, Client> remoteClient, ClusterService clusterService, AllocationService allocationService) {
        this.settings = settings;
        this.threadPool = threadPool;
        this.replicationService = replicationService;
        this.replicationSettings = replicationSettings;
        this.remoteClient = remoteClient;
        this.clusterService = clusterService;
        this.indexScopedSettings = indexScopedSettings;
        this.allocationService = allocationService;
    }

    private void start() {
        assert (!this.isActive) : "MetadataTracker is already started";
        assert (this.clusterService.state().nodes().isLocalNodeElectedMaster()) : "MetadataTracker must only be run on the master node";
        RetryRunnable runnable = new RetryRunnable(this.threadPool, "logical_replication", this::run, BackoffPolicy.exponentialBackoff(this.replicationSettings.pollDelay(), 8));
        this.cancellable = runnable;
        this.isActive = true;
        runnable.run();
    }

    private void stop() {
        this.isActive = false;
        Scheduler.Cancellable currentCancellable = this.cancellable;
        if (currentCancellable != null) {
            currentCancellable.cancel();
        }
    }

    private void schedule() {
        if (!this.isActive) {
            return;
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Reschedule tracking metadata");
        }
        this.cancellable = this.threadPool.scheduleUnlessShuttingDown(this.replicationSettings.pollDelay(), "logical_replication", this::run);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Collection<String> subscriptionNames) {
        MetadataTracker metadataTracker = this;
        synchronized (metadataTracker) {
            if (subscriptionNames.isEmpty()) {
                this.stop();
            } else {
                this.subscriptionsToTrack = new HashSet<String>(subscriptionNames);
                if (!this.isActive) {
                    this.start();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopTracking(String subscriptionName) {
        MetadataTracker metadataTracker = this;
        synchronized (metadataTracker) {
            HashSet<String> copy = new HashSet<String>(this.subscriptionsToTrack);
            boolean updated = copy.remove(subscriptionName);
            if (this.isActive && copy.isEmpty()) {
                this.stop();
            }
            this.subscriptionsToTrack = copy;
            return updated;
        }
    }

    private void run() {
        Set<String> currentSubscriptionsToTrack = this.subscriptionsToTrack;
        CountdownFuture countDown = new CountdownFuture(currentSubscriptionsToTrack.size());
        countDown.thenRun(this::schedule);
        for (String subscriptionName : currentSubscriptionsToTrack) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Poll metadata for subscription {}", (Object)subscriptionName);
            }
            this.processSubscription(subscriptionName).whenComplete((BiConsumer)countDown);
        }
    }

    private CompletableFuture<?> processSubscription(String subscriptionName) {
        Client client;
        ClusterState subscriberState = this.clusterService.state();
        Subscription subscription = SubscriptionsMetadata.get(subscriberState.metadata()).get(subscriptionName);
        if (subscription == null) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Subscription {} not found inside current local cluster state", (Object)subscriptionName);
            }
            return CompletableFuture.completedFuture(null);
        }
        try {
            client = this.remoteClient.apply(subscriptionName);
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(e);
        }
        PublicationsStateAction.Request request = new PublicationsStateAction.Request(subscription.publications(), subscription.connectionInfo().user());
        CompletableFuture<PublicationsStateAction.Response> publicationsState = client.execute(PublicationsStateAction.INSTANCE, request);
        CompletionStage updatedClusterState = publicationsState.thenCompose(response -> {
            if (response.unknownPublications().containsAll(subscription.publications())) {
                this.stopTracking(subscriptionName);
                return CompletableFuture.completedFuture(false);
            }
            Set<RelationName> existingTables = MetadataTracker.getExistingLocallyTables(subscription, subscriberState, response);
            if (!existingTables.isEmpty()) {
                String msg = String.format(Locale.ENGLISH, "Tracking of metadata failed for subscription '" + subscriptionName + "', stopping tracking. Some relation(s) already exist. Check table pg_subscription_rel to see existing tables.", subscriptionName);
                LOGGER.error(msg);
                return this.replicationService.updateSubscriptionState(subscriptionName, existingTables, Subscription.State.FAILED, "Relation already exists").handle((ignoredAck, ignoredErr) -> {
                    this.stopTracking(subscriptionName);
                    return false;
                });
            }
            return this.updateClusterState(subscriptionName, (PublicationsStateAction.Response)response);
        });
        return ((CompletableFuture)((CompletableFuture)updatedClusterState).thenCompose(acked -> {
            if (!acked.booleanValue()) {
                return CompletableFuture.completedFuture(false);
            }
            assert (publicationsState.isDone()) : "If thenCompose triggers, publicationsState must be done";
            PublicationsStateAction.Response publicationResponse = (PublicationsStateAction.Response)publicationsState.join();
            RestoreDiff restoreDiff = MetadataTracker.getRestoreDiff(subscription, subscriberState, publicationResponse);
            if (restoreDiff.isEmpty()) {
                return CompletableFuture.completedFuture(true);
            }
            CompletableFuture<Boolean> updateState = restoreDiff.relationsForStateUpdate.isEmpty() ? CompletableFuture.completedFuture(true) : this.replicationService.updateSubscriptionState(subscriptionName, restoreDiff.relationsForStateUpdate, Subscription.State.INITIALIZING, null);
            return updateState.thenCompose(ignored -> this.replicationService.restore(subscriptionName, subscription.settings(), restoreDiff.relationsForStateUpdate, restoreDiff.indexNamesToRestore, restoreDiff.templatesToRestore));
        })).exceptionallyCompose(err -> {
            Throwable e = SQLExceptions.unwrap(err);
            if (SQLExceptions.maybeTemporary(e)) {
                LOGGER.warn("Retrieving remote metadata failed for subscription '" + subscriptionName + "', will retry", e);
                return CompletableFuture.completedFuture(null);
            }
            if (e instanceof SubscriptionUnknownException) {
                this.stopTracking(subscriptionName);
                return CompletableFuture.completedFuture(null);
            }
            String msg = "Tracking of metadata failed for subscription '" + subscriptionName + "' with unrecoverable error, stop tracking";
            LOGGER.error(msg, e);
            return this.replicationService.updateSubscriptionState(subscriptionName, Subscription.State.FAILED, msg + ".\nReason: " + e.getMessage()).handle((ignoredAck, ignoredErr) -> {
                this.stopTracking(subscriptionName);
                return null;
            });
        });
    }

    private CompletableFuture<Boolean> updateClusterState(final String subscriptionName, final PublicationsStateAction.Response response) {
        AckedClusterStateUpdateTask<AcknowledgedResponse> updateTask = new AckedClusterStateUpdateTask<AcknowledgedResponse>(this, (AckedRequest)new AckMetadataUpdateRequest()){
            final /* synthetic */ MetadataTracker this$0;
            {
                this.this$0 = this$0;
                super(request);
            }

            @Override
            public ClusterState execute(ClusterState localClusterState) throws Exception {
                Metadata localMetadata;
                Subscription subscription;
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Process cluster state for subscription {}", (Object)subscriptionName);
                }
                if ((subscription = SubscriptionsMetadata.get(localMetadata = localClusterState.metadata()).get(subscriptionName)) == null) {
                    LOGGER.warn("Subscription {} disappeared", (Object)subscriptionName);
                    return localClusterState;
                }
                localClusterState = this.this$0.processDroppedTablesOrPartitions(subscriptionName, subscription, localClusterState, response.relationsInPublications());
                return MetadataTracker.updateIndexMetadata(subscriptionName, subscription, localClusterState, response, this.this$0.indexScopedSettings);
            }

            @Override
            protected AcknowledgedResponse newResponse(boolean acknowledged) {
                return new AcknowledgedResponse(acknowledged);
            }
        };
        this.clusterService.submitStateUpdateTask("track-metadata", updateTask);
        return updateTask.completionFuture().thenApply(AcknowledgedResponse::isAcknowledged);
    }

    @VisibleForTesting
    static ClusterState updateIndexMetadata(String subscriptionName, Subscription subscription, ClusterState subscriberClusterState, PublicationsStateAction.Response publicationsState, IndexScopedSettings indexScopedSettings) {
        Metadata.Builder updatedMetadataBuilder = Metadata.builder(subscriberClusterState.metadata());
        boolean updateClusterState = false;
        for (RelationName followedTable : subscription.relations().keySet()) {
            Settings updatedSettings;
            RelationMetadata relationMetadata = publicationsState.relationsInPublications().get(followedTable);
            Map publisherIndices = relationMetadata == null ? Map.of() : relationMetadata.indices().stream().collect(Collectors.toMap(x -> x.getIndex().getName(), x -> x));
            IndexMetadata publisherIndexMetadata = (IndexMetadata)publisherIndices.get(followedTable.indexNameOrAlias());
            IndexMetadata subscriberIndexMetadata = subscriberClusterState.metadata().index(followedTable.indexNameOrAlias());
            if (publisherIndexMetadata == null || subscriberIndexMetadata == null) continue;
            IndexMetadata.Builder updatedIndexMetadataBuilder = IndexMetadata.builder(subscriberIndexMetadata);
            MappingMetadata updatedMapping = MetadataTracker.updateIndexMetadataMappings(publisherIndexMetadata, subscriberIndexMetadata);
            if (updatedMapping != null) {
                updatedIndexMetadataBuilder.putMapping(updatedMapping).mappingVersion(publisherIndexMetadata.getMappingVersion());
            }
            if ((updatedSettings = MetadataTracker.updateIndexMetadataSettings(publisherIndexMetadata.getSettings(), subscriberIndexMetadata.getSettings(), indexScopedSettings)) != null) {
                updatedIndexMetadataBuilder.settings(updatedSettings).settingsVersion(subscriberIndexMetadata.getSettingsVersion() + 1L);
            }
            if (updatedMapping == null && updatedSettings == null) continue;
            updatedMetadataBuilder.put(updatedIndexMetadataBuilder.build(), true);
            updateClusterState = true;
        }
        if (updateClusterState) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Updated index metadata for subscription {}", (Object)subscriptionName);
            }
            return ClusterState.builder(subscriberClusterState).metadata(updatedMetadataBuilder).build();
        }
        return subscriberClusterState;
    }

    private static Set<RelationName> getExistingLocallyTables(Subscription subscription, ClusterState subscriberClusterState, PublicationsStateAction.Response publisherStateResponse) {
        Metadata metadata = subscriberClusterState.metadata();
        Set<RelationName> currentlyReplicatedTables = subscription.relations().keySet();
        Set existingRelations = publisherStateResponse.concreteIndices().stream().filter(im -> metadata.hasIndex(im.getIndex().getName())).map(im -> RelationName.fromIndexName(im.getIndex().getName())).filter(relationName -> !currentlyReplicatedTables.contains(relationName)).collect(Collectors.toCollection(() -> new HashSet()));
        for (String t : publisherStateResponse.concreteTemplates()) {
            RelationName relationName2;
            if (!metadata.templates().containsKey(t) || currentlyReplicatedTables.contains(relationName2 = PartitionName.fromIndexOrTemplate(t).relationName())) continue;
            existingRelations.add(relationName2);
        }
        return existingRelations;
    }

    @VisibleForTesting
    static RestoreDiff getRestoreDiff(Subscription subscription, ClusterState subscriberState, PublicationsStateAction.Response stateResponse) {
        Map<RelationName, Subscription.RelationState> subscribedRelations = subscription.relations();
        HashSet<RelationName> relationNamesForStateUpdate = new HashSet<RelationName>();
        ArrayList<String> toRestoreIndices = new ArrayList<String>();
        ArrayList<String> toRestoreTemplates = new ArrayList<String>();
        Metadata subscriberMetadata = subscriberState.metadata();
        for (IndexMetadata indexMetadata : stateResponse.concreteIndices()) {
            String indexName = indexMetadata.getIndex().getName();
            IndexParts indexParts = IndexName.decode(indexName);
            RelationName relationName = indexParts.toRelationName();
            if (subscribedRelations.get(relationName) == null) {
                relationNamesForStateUpdate.add(relationName);
            }
            if (!LogicalReplicationSettings.REPLICATION_INDEX_ROUTING_ACTIVE.get(indexMetadata.getSettings()).booleanValue()) {
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Skipping index {} for subscription {} as it is not active", (Object)indexName, (Object)subscription);
                continue;
            }
            if (subscriberMetadata.hasIndex(indexName)) continue;
            toRestoreIndices.add(indexName);
            relationNamesForStateUpdate.add(relationName);
        }
        for (String templateName : stateResponse.concreteTemplates()) {
            IndexParts indexParts = IndexName.decode(templateName);
            if (!indexParts.isPartitioned()) continue;
            RelationName relationName = indexParts.toRelationName();
            if (subscriberState.metadata().templates().get(templateName) == null) {
                toRestoreTemplates.add(templateName);
            }
            if (subscribedRelations.get(relationName) != null) continue;
            relationNamesForStateUpdate.add(relationName);
        }
        if (toRestoreIndices.isEmpty() && toRestoreTemplates.isEmpty()) {
            relationNamesForStateUpdate.clear();
        }
        return new RestoreDiff(toRestoreIndices, toRestoreTemplates, relationNamesForStateUpdate);
    }

    private ClusterState processDroppedTablesOrPartitions(String subscriptionName, Subscription subscription, ClusterState subscriberClusterState, Map<RelationName, RelationMetadata> relationsInPublications) {
        HashSet<RelationName> changedRelations = new HashSet<RelationName>();
        HashSet<Index> partitionsToRemove = new HashSet<Index>();
        Metadata subscriberMetadata = subscriberClusterState.metadata();
        for (RelationName relationName : subscription.relations().keySet()) {
            Index[] concreteIndices;
            boolean relationDisappeared;
            RelationMetadata publisherRelationMetadata = relationsInPublications.get(relationName);
            boolean bl = relationDisappeared = publisherRelationMetadata == null;
            if (relationDisappeared) {
                changedRelations.add(relationName);
                continue;
            }
            for (Index concreteIndex : concreteIndices = IndexNameExpressionResolver.concreteIndices(subscriberClusterState.metadata(), IndicesOptions.LENIENT_EXPAND_OPEN_CLOSED, relationName.indexNameOrAlias())) {
                IndexMetadata subscriberIndexMetadata = subscriberMetadata.index(concreteIndex);
                String indexUUID = LogicalReplicationSettings.PUBLISHER_INDEX_UUID.get(subscriberIndexMetadata.getSettings());
                boolean publisherContainsIndex = publisherRelationMetadata.indices().stream().anyMatch(x -> x.getIndexUUID().equals(indexUUID));
                if (publisherContainsIndex) continue;
                partitionsToRemove.add(concreteIndex);
            }
        }
        ClusterState updatedClusterState = subscriberClusterState;
        if (!partitionsToRemove.isEmpty()) {
            updatedClusterState = MetadataDeleteIndexService.deleteIndices(updatedClusterState, this.settings, this.allocationService, partitionsToRemove);
        }
        if (!changedRelations.isEmpty()) {
            HashMap<RelationName, Subscription.RelationState> relations = new HashMap<RelationName, Subscription.RelationState>();
            for (Map.Entry<RelationName, Subscription.RelationState> entry : subscription.relations().entrySet()) {
                RelationName relationName = entry.getKey();
                if (changedRelations.contains(relationName)) continue;
                Subscription.RelationState state = entry.getValue();
                relations.put(relationName, state);
            }
            updatedClusterState = DropSubscriptionAction.removeSubscriptionSetting(changedRelations, updatedClusterState, Metadata.builder(updatedClusterState.metadata()));
            updatedClusterState = UpdateSubscriptionAction.update(updatedClusterState, subscriptionName, new Subscription(subscription.owner(), subscription.connectionInfo(), subscription.publications(), subscription.settings(), relations));
        }
        return updatedClusterState;
    }

    @Nullable
    private static MappingMetadata updateIndexMetadataMappings(IndexMetadata publisherIndexMetadata, IndexMetadata subscriberIndexMetadata) {
        MappingMetadata publisherMapping = publisherIndexMetadata.mapping();
        MappingMetadata subscriberMapping = subscriberIndexMetadata.mapping();
        if (publisherMapping != null && subscriberMapping != null && publisherIndexMetadata.getMappingVersion() > subscriberIndexMetadata.getMappingVersion()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Updated index mapping {} for subscription {}", (Object)subscriberIndexMetadata.getIndex().getName(), (Object)publisherMapping.toString());
            }
            return publisherMapping;
        }
        return null;
    }

    @Nullable
    private static Settings updateIndexMetadataSettings(Settings publisherMetadataSettings, Settings subscriberMetadataSettings, IndexScopedSettings indexScopedSettings) {
        Settings.Builder newSettingsBuilder = Settings.builder().put(subscriberMetadataSettings);
        Settings updatedSettings = publisherMetadataSettings.filter(key -> MetadataTracker.isReplicatableSetting(key, indexScopedSettings) && !Objects.equals(subscriberMetadataSettings.get((String)key), publisherMetadataSettings.get((String)key)));
        if (updatedSettings.isEmpty()) {
            return null;
        }
        return newSettingsBuilder.put(updatedSettings).build();
    }

    private static boolean isReplicatableSetting(String key, IndexScopedSettings indexScopedSettings) {
        Setting<?> setting = indexScopedSettings.get(key);
        return setting != null && !setting.isInternalIndex() && !setting.isPrivateIndex() && indexScopedSettings.isDynamicSetting(key) && !indexScopedSettings.isPrivateSetting(key) && !LogicalReplicationSettings.NON_REPLICATED_SETTINGS.contains(setting);
    }

    @Override
    public void close() {
        this.stop();
    }

    @VisibleForTesting
    public boolean isActive() {
        return this.isActive;
    }

    private static class AckMetadataUpdateRequest
    extends AcknowledgedRequest<AckMetadataUpdateRequest> {
        private AckMetadataUpdateRequest() {
        }
    }

    record RestoreDiff(List<String> indexNamesToRestore, List<String> templatesToRestore, Set<RelationName> relationsForStateUpdate) {
        public boolean isEmpty() {
            return this.indexNamesToRestore.isEmpty() && this.templatesToRestore.isEmpty();
        }
    }
}

