/*
 * Decompiled with CFR 0.152.
 */
package io.crate.replication.logical;

import io.crate.replication.logical.LogicalReplicationService;
import io.crate.replication.logical.LogicalReplicationSettings;
import io.crate.replication.logical.ShardReplicationChangesTracker;
import io.crate.replication.logical.exceptions.NoSubscriptionForIndexException;
import io.crate.replication.logical.metadata.Subscription;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.shard.IndexEventListener;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.RemoteClusters;
import org.jetbrains.annotations.Nullable;

public class ShardReplicationService
implements Closeable,
IndexEventListener {
    private static final Logger LOGGER = LogManager.getLogger(ShardReplicationService.class);
    private final LogicalReplicationService logicalReplicationService;
    private final LogicalReplicationSettings replicationSettings;
    private final Client client;
    private final ThreadPool threadPool;
    private final ClusterName clusterName;
    private final Map<ShardId, ShardReplicationChangesTracker> shards = new ConcurrentHashMap<ShardId, ShardReplicationChangesTracker>();
    private final RemoteClusters remoteClusters;

    @Inject
    public ShardReplicationService(LogicalReplicationService logicalReplicationService, LogicalReplicationSettings replicationSettings, RemoteClusters remoteClusters, Client client, ThreadPool threadPool, ClusterService clusterService) {
        this.logicalReplicationService = logicalReplicationService;
        this.replicationSettings = replicationSettings;
        this.remoteClusters = remoteClusters;
        this.client = client;
        this.threadPool = threadPool;
        this.clusterName = clusterService.getClusterName();
    }

    @Override
    public void close() throws IOException {
        for (ShardReplicationChangesTracker tracker : this.shards.values()) {
            tracker.close();
        }
    }

    CompletableFuture<Client> getRemoteClusterClient(Index index, String subscriptionName) {
        Subscription subscription = this.logicalReplicationService.subscriptions().get(subscriptionName);
        if (subscription == null) {
            return CompletableFuture.failedFuture(new NoSubscriptionForIndexException(index));
        }
        return this.remoteClusters.connect(subscriptionName, subscription.connectionInfo());
    }

    @Override
    public void afterIndexShardStarted(IndexShard indexShard) {
        if (indexShard.routingEntry().primary()) {
            String subscriptionName = LogicalReplicationSettings.REPLICATION_SUBSCRIPTION_NAME.get(indexShard.indexSettings().getSettings());
            if (subscriptionName == null) {
                return;
            }
            Subscription subscription = this.logicalReplicationService.subscriptions().get(subscriptionName);
            if (subscription != null) {
                ShardReplicationChangesTracker tracker = new ShardReplicationChangesTracker(subscriptionName, indexShard, this.threadPool, this.replicationSettings, this, this.clusterName.value(), this.client);
                this.shards.put(indexShard.shardId(), tracker);
                tracker.start();
            }
        }
    }

    @Override
    public void beforeIndexShardClosed(ShardId shardId, @Nullable IndexShard indexShard, Settings indexSettings) {
        this.closeTracker(shardId);
    }

    @Override
    public void beforeIndexShardDeleted(ShardId shardId, Settings indexSettings) {
        this.closeTracker(shardId);
    }

    @Override
    public void beforeIndexSettingsChangesApplied(IndexShard indexShard, Settings oldSettings, Settings newSettings) {
        if (!LogicalReplicationSettings.REPLICATION_SUBSCRIPTION_NAME.get(oldSettings).isEmpty() && LogicalReplicationSettings.REPLICATION_SUBSCRIPTION_NAME.get(newSettings).isEmpty()) {
            ShardId shardId = indexShard.shardId();
            this.closeTracker(shardId);
        }
    }

    private void closeTracker(ShardId shardId) {
        ShardReplicationChangesTracker tracker = this.shards.remove(shardId);
        if (tracker != null) {
            try {
                tracker.close();
            }
            catch (IOException e) {
                LOGGER.error("Error while closing shard changes tracker of shardId=" + String.valueOf(shardId), (Throwable)e);
            }
        }
    }
}

